% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{runCluster}
\alias{runCluster}
\title{SNN Graph Based Community Detection}
\usage{
runCluster(
  object,
  resolution = 1,
  nNeighbors = 20,
  prune = 1/15,
  eps = 0.1,
  nRandomStarts = 10,
  nIterations = 5,
  method = c("leiden", "louvain"),
  useRaw = NULL,
  useDims = NULL,
  groupSingletons = TRUE,
  saveSNN = FALSE,
  clusterName = paste0(method, "_cluster"),
  seed = 1,
  verbose = getOption("ligerVerbose", TRUE)
)
}
\arguments{
\item{object}{A \linkS4class{liger} object. Should have valid factorization
result available.}

\item{resolution}{Numeric, value of the resolution parameter, a larger value
results in a larger number of communities with smaller sizes. Default
\code{1.0}.}

\item{nNeighbors}{Integer, the maximum number of nearest neighbors to
compute. Default \code{20}.}

\item{prune}{Numeric. Sets the cutoff for acceptable Jaccard index when
computing the neighborhood overlap for the SNN construction. Any edges with
values less than or equal to this will be set to 0 and removed from the SNN
graph. Essentially sets the stringency of pruning. \code{0} for no pruning,
while \code{1} prunes everything. Default \code{1/15}.}

\item{eps}{Numeric, the error bound of the nearest neighbor search. Default
\code{0.1}.}

\item{nRandomStarts}{Integer number of random starts. Will pick the
membership with highest quality to return. Default \code{10}.}

\item{nIterations}{Integer, maximal number of iterations per random start.
Default \code{5}.}

\item{method}{Community detection algorithm to use. Choose from
\code{"leiden"} or \code{"louvain"}. Default \code{"leiden"}.}

\item{useRaw}{Whether to use un-aligned cell factor loadings (\eqn{H}
matrices). Default \code{NULL} search for quantile-normalized loadings first
and un-aligned loadings then.}

\item{useDims}{Indices of factors to use for clustering. Default \code{NULL}
uses all available factors.}

\item{groupSingletons}{Whether to group single cells that make up their own
cluster in with the cluster they are most connected to. Default \code{TRUE},
if \code{FALSE}, assign all singletons to a \code{"singleton"} group.}

\item{saveSNN}{Logical, whether to store the SNN graph, as a dgCMatrix
object, in the object. Default \code{FALSE}.}

\item{clusterName}{Name of the variable that will store the clustering result
in \code{cellMeta} slot of \code{object}. Default \code{"leiden_cluster"} and
\code{"louvain_cluster"}.}

\item{seed}{Seed of the random number generator. Default \code{1}.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}
}
\value{
\code{object} with cluster assignment updated in \code{clusterName}
variable in \code{cellMeta} slot. Can be fetched with
\code{object[[clusterName]]}. If \code{saveSNN = TRUE}, the SNN graph will
be stored at \code{object@uns$snn}.
}
\description{
After aligning cell factor loadings, users can additionally run the Leiden or
Louvain algorithm for community detection, which is widely used in
single-cell analysis and excels at merging small clusters into broad cell
classes.

While using aligned factor loadings (result from \code{\link{alignFactors}})
is recommended, this function looks for unaligned factor loadings (raw result
from \code{\link{runIntegration}}) when the former is not available.
}
\examples{
pbmcPlot <- runCluster(pbmcPlot)
head(pbmcPlot$leiden_cluster)
pbmcPlot <- runCluster(pbmcPlot, method = "louvain")
head(pbmcPlot$louvain_cluster)
}
