% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{read10XH5}
\alias{read10XH5}
\alias{read10XH5Mem}
\alias{read10XH5Delay}
\title{Read 10X HDF5 file}
\usage{
read10XH5(filename, inMemory = TRUE, useNames = TRUE, featureMakeUniq = TRUE)

read10XH5Mem(filename, useNames = TRUE, featureMakeUniq = TRUE)

read10XH5Delay(filename, useNames = TRUE, featureMakeUniq = TRUE)
}
\arguments{
\item{filename}{Character string, path to the HDF5 file.}

\item{inMemory}{Logical, whether to load the data into memory. Default
\code{TRUE}. \code{FALSE} loads the data as a \code{DelayedArray} object.}

\item{useNames}{Logical, whether to use gene names as row names. Default
\code{TRUE}. \code{FALSE} uses gene IDs instead.}

\item{featureMakeUniq}{Logical, whether to make gene names unique. Default
\code{TRUE}.}
}
\value{
A sparse matrix when only using older CellRanger output HDF5 file or
when only one genome and one modality is detected. When multiple genomes are
available, will return a list for each genome. When using multimodal data,
each genome will be a list of matrices for each modality. The matrix will be
of dgCMatrix class when in memory, or a TENxMatrix object when in delayed
mode.
}
\description{
Read count matrix from 10X CellRanger HDF5 file. By default, \code{read10XH5}
load scRNA, scATAC or multimodal data into memory (\code{inMemory = TRUE}).
To use LIGER in delayed mode for handling large datasets, set
\code{inMemory = FALSE} to load the data as a \code{DelayedArray} object. The
delayed mode only supports scRNA data for now.
}
\examples{
matrix <- read10XH5(
    filename = system.file("extdata/ctrl.h5", package = "rliger"),
    inMemory = TRUE
)
class(matrix) # Should show dgCMatrix
if (requireNamespace("HDF5Array", quietly = TRUE)) {
   matrix <- read10XH5(
      filename = system.file("extdata/ctrl.h5", package = "rliger"),
      inMemory = FALSE
   )
   print(class(matrix)) # Should show TENxMatrix
}
}
