% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KrigingClass.R
\name{load.Kriging}
\alias{load.Kriging}
\title{Load a Kriging Model from a file storage}
\usage{
load.Kriging(filename, ...)
}
\arguments{
\item{filename}{File name to load from.}

\item{...}{Not used.}
}
\value{
The loaded Kriging object.
}
\description{
Load a Kriging Model from a file storage
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)

k <- Kriging(y, X, kernel = "matern3_2", objective="LMP")
print(k)

outfile = tempfile("k.json")
save(k,outfile)

print(load.Kriging(outfile)) 
}
\author{
Yann Richet \email{yann.richet@asnr.fr}
}
