% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjstat.R
\name{fromJSONstat}
\alias{fromJSONstat}
\title{Convert JSON-stat format to data frame(s)}
\usage{
fromJSONstat(x, naming = "label", use_factors = FALSE, silent = FALSE)
}
\arguments{
\item{x}{JSON-stat format response, or path or URL to such a response}

\item{naming}{whether to use (longer) \code{label}s or (shorter) \code{id}s}

\item{use_factors}{whether dimension categories should be factors or
character objects}

\item{silent}{suppress warnings}
}
\value{
For responses with class \code{dataset}: A data frame. For responses
  with class \code{collection}: An unnamed list of one or more lists or data
  frames. For responses with class \code{bundle}: A named list of one or more
  data frames.
}
\description{
This function takes a JSON-stat format response and returns a data frame or a
list of data frames, with columns for each dimension and one \code{value}
column.
}
\examples{
\dontrun{
oecd.canada.url <- "http://json-stat.org/samples/oecd-canada.json"
results <- fromJSONstat(oecd.canada.url)
names(results)
}
}

