% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_util.R
\name{is_valid_prob_pair}
\alias{is_valid_prob_pair}
\title{Verify that a pair of probability inputs
can be a pair of complementary probabilities.}
\usage{
is_valid_prob_pair(p1, p2, tol = 0.01)
}
\arguments{
\item{p1}{A numeric argument
(typically probability in range from 0 to 1).}

\item{p2}{A numeric argument
(typically probability in range from 0 to 1).}

\item{tol}{A numeric tolerance value.}
}
\value{
A Boolean value:
\code{TRUE} if exactly one argument is a probability,
if both arguments are probabilities and complements,
otherwise \code{FALSE}.
}
\description{
\code{is_valid_prob_pair} is a function that verifies that
a pair of 2 numeric inputs \code{p1} and \code{p2}
can be interpreted as a valid pair of probabilities.
}
\details{
\code{is_valid_prob_pair} is a wrapper function
that combines \code{\link{is_prob}} and
\code{\link{is_complement}} in one function.

Either \code{p1} or \code{p2} must be a probability
(verified via \code{\link{is_prob}}).
If both arguments are provided they must be
probabilities and complements
(verified via \code{\link{is_complement}}).

The argument \code{tol} is optional (with a default value of .01)
Numeric near-complements that differ by less than this
value are still considered to be complements.
}
\examples{
# ways to succeed:
is_valid_prob_pair(1, 0)      # => TRUE
is_valid_prob_pair(0, 1)      # => TRUE
is_valid_prob_pair(1, NA)     # => TRUE + warning (NA)
is_valid_prob_pair(NA, 1)     # => TRUE + warning (NA)
is_valid_prob_pair(.50, .51)  # => TRUE (as within tol)

# ways to fail:
is_valid_prob_pair(.50, .52)  # => FALSE (as beyond tol)
is_valid_prob_pair(1, 2)      # => FALSE + warning (beyond range)
is_valid_prob_pair(NA, NA)    # => FALSE + warning (NA)

}
\seealso{
\code{\link{is_valid_prob_set}} uses this function to verify sets of probability inputs;
\code{\link{is_complement}} verifies numeric complements;
\code{\link{is_prob}} verifies probabilities;
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{as_pc}} displays a probability as a percentage;
\code{\link{as_pb}} displays a percentage as probability.

Other verification functions: 
\code{\link{is_complement}()},
\code{\link{is_extreme_prob_set}()},
\code{\link{is_freq}()},
\code{\link{is_integer}()},
\code{\link{is_matrix}()},
\code{\link{is_perc}()},
\code{\link{is_prob}()},
\code{\link{is_suff_prob_set}()},
\code{\link{is_valid_prob_set}()},
\code{\link{is_valid_prob_triple}()}
}
\concept{verification functions}
