% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rif.R
\name{get_rif_mean}
\alias{get_rif_mean}
\title{Estimate RIF at the Mean}
\usage{
get_rif_mean(dep_var)
}
\arguments{
\item{dep_var}{dependent variable of a distributional function. Discrete or continuous numeric vector.}
}
\value{
A data frame with one column of \code{length(dep_var)} containing the RIF at the mean.
}
\description{
Function to estimate the recentered influence function (RIF) at the mean
of a weighted distribution of a dependent variable.
}
\examples{

dep_var <- c(1, 3, 9, 16, 3, 7, 4, 9)
get_rif_mean(dep_var)

}
