% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_min_mesh_constraint.R
\name{add_min_mesh_constraint}
\alias{add_min_mesh_constraint}
\title{Add constraint to enforce a minimum effective mesh size (MESH) value}
\usage{
add_min_mesh_constraint(problem, min_mesh, precision = 4, unit = "ha")
}
\arguments{
\item{problem}{\code{\link[=restopt_problem]{restopt_problem()}} Restoration problem object.}

\item{min_mesh}{\code{numeric} Minimum MESH value.}

\item{precision}{\code{integer} Precision for calculations.
Defaults to 4.}

\item{unit}{\code{unit} object or a \code{character} that can be coerced to an area
unit (see \code{unit} package), or "cells" for cell width of aggregated
habitat raster. Corresponds to the unit of the minimum mesh value If the
input habitat raster does not use a projected coordinate system, only "cells"
is available. Defaults to "ha".}
}
\value{
An updated restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) object.
}
\description{
Add constraint to a restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) object
to specify the minimum effective mesh size of a solution.
}
\details{
The effective mesh size (MESH) is a measure of landscape fragmentation
based on the probability that two randomly chosen points are located in the
same patch (Jaeger, 2000). Maximizing it in the context of restoration
favours fewer and larger patches.
}
\examples{
\donttest{
# load data
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)

# create problem
p <- restopt_problem(
    existing_habitat = habitat_data,
    aggregation_factor = 16,
    habitat_threshold = 0.7
  ) \%>\%
  add_restorable_constraint(
    min_restore = 200,
    max_restore = 300,
  ) \%>\%
  add_min_mesh_constraint(min_mesh = 2500, unit = "ha")

# plot preprocessed data
plot(rast(list(p$data$existing_habitat, p$data$restorable_habitat)), nc = 2)

# print problem
print(p)

# Solve problem
s <- solve(p)
# plot solution
plot(s)
}

}
\references{
Jaeger, J. A. G. (2000). Landscape division, splitting index, and effective
mesh size: New measures of landscape fragmentation. Landscape Ecology, 15(2),
115‑130. https://doi.org/10.1023/A:1008129329289
}
\seealso{
\link{set_max_mesh_objective}

Other constraints: 
\code{\link{add_available_areas_constraint}()},
\code{\link{add_compactness_constraint}()},
\code{\link{add_components_constraint}()},
\code{\link{add_connected_constraint}()},
\code{\link{add_locked_out_constraint}()},
\code{\link{add_min_iic_constraint}()},
\code{\link{add_restorable_constraint}()}
}
\concept{constraints}
