% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{predict_gaussian_process}
\alias{predict_gaussian_process}
\title{Prediction function for the \code{gaussian_process} function (Gaussian process regression with dot product covariance)}
\usage{
predict_gaussian_process(Xz, alpha, newdata, scale, Xcenter, Xscale, Ycenter, Yscale)
}
\arguments{
\item{newdata}{a matrix containing the predictor variables}

\item{scale}{a logical indicating whether the matrix of predictors used to create the regression model
(in the \code{gaussian_process} function) was scaled}

\item{Xcenter}{if \code{center = TRUE} a matrix of one row with the values that must be used for centering \code{newdata}.}

\item{Xscale}{if \code{scale = TRUE} a matrix of one row with the values that must be used for scaling \code{newdata}.}

\item{Ycenter}{if \code{center = TRUE} a matrix of one row with the values that must be used for accounting for the centering of the response variable.}

\item{Yscale}{if \code{scale = TRUE} a matrix of one row with the values that must be used  for accounting for the scaling of the response variable.}
}
\value{
a matrix of predicted values
}
\description{
Predicts response values based on a model generated by the \code{gaussian_process} function (Gaussian process regression with dot product covariance). For internal use only!.
}
\author{
Leonardo Ramirez-Lopez
}
\keyword{internal}
