% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeApiCall.R
\name{makeApiCall}
\alias{makeApiCall}
\title{Make REDCap API Calls}
\usage{
makeApiCall(
  rcon,
  body = list(),
  url = NULL,
  success_status_codes = 200L,
  redirect = TRUE,
  ...
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{body}{\code{list} List of parameters to be passed to \link[curl:curl]{curl::curl}'s
\code{body} argument}

\item{url}{\code{character(1)} A url string to hit. Defaults to rcon$url.}

\item{success_status_codes}{\code{integerish} A vector of success codes to ignore
for error handling. Defaults to c(200L).}

\item{redirect}{\code{logical(1)} Is redirection on the request allowed?}

\item{...}{This will capture \code{api_param} (if specified) which will modify the body of the
the specified body of the request. It also captures \code{config} which will get
passed to curl::handle_setopt.}
}
\description{
Constructs and executes API calls to the REDCap API. These
are left deliberately abstract in order to be flexible enough to
support the \code{redcapAPI} functions, but also allow users to
execute calls for new REDCap features that are not yet implemented.
}
\details{
The intent of this function is to provide an approach to execute
calls to the REDCap API that is both consistent and flexible. Importantly,
this provides a framework for making calls to the API using features that
the R package does not yet support (redcapAPI will always lag behind when
REDCap adds new features).

The API call consists of two components: the "body" and the "config."
The body of the call contains all of the arguments being passed to the
API. When building body components, be sure to review the documentation.
options to the API that require an array need to be built using
\code{vectorToApiBodyList}; options that are not an array can be entered
directly (see examples).

The config list is a list of parameter overrides that reflect the curl
request object. The most commonly used elements of this list
is \code{options} or maybe \code{headers}.

Using the settings stored in the \code{redcapConnection} object, a response
code of 408 (Request Timeout), 500 (Internal Server Error),
502 (Bad Gateway), 503 (Service Unavailable), or 504 (Gateway Timeout)
will prompt reattempts at calling the API. See \code{\link[=redcapConnection]{redcapConnection()}}
for details. If the API reaches its attempt limit without resolving to
any other code, the last response is returned. If any other response
code is returned at any point in the retry loop, the loop breaks and
returns that response.
}
\examples{
\dontrun{
  url <- "Enter your API URL here"
  token <- "Enter your API token here"

  rcon <- redcapConnection(url = url,
                           token = token)

  MetaData <-
    makeApiCall(rcon = rcon,
               body = list(content = "metadata",
                           format = "csv",
                           returnFormat = "csv"))
  MetaData <- utils::read.csv(text = as.character(MetaData),
                              stringsAsFactors = FALSE,
                              na.strings = "")



  # Call to export Meta Data (Data Dictionary) for specific fields

  fields <- vectorToApiBodyList(vector = c("row_purpose",
                                           "prereq_radio"),
                                parameter_name = "fields")
  MetaData <-
    makeApiCall(rcon = rcon,
                body = c(list(content = "metadata",
                              format = "csv",
                              returnFormat = "csv"),
                         fields))
  MetaData <- read.csv(text = as.character(MetaData),
                       stringsAsFactors = FALSE,
                       na.strings = "")



  # Basic call to export records

  Records <- makeApiCall(rcon = rcon,
                         body = list(content = "record",
                                     format = "csv",
                                     returnFormat = "csv",
                                     type = "flat"))

  Records <- read.csv(text = as.character(Records),
                      stringsAsFactors = FALSE,
                      na.strings = "")


  # Call to export records for a single form.
  # Note that even though we are interested in a single form, the
  # API requires an array, so we use vectorToApiBodyList

  export_form <- vectorToApiBodyList("branching_logic",
                                     parameter_name = "forms")
  Records <- makeApiCall(rcon = rcon,
                         body = c(list(content = "record",
                                       format = "csv",
                                       returnFormat = "csv",
                                       type = "flat"),
                                  export_form))
  Records <- read.csv(text = as.character(Records),
                      stringsAsFactors = FALSE,
                      na.strings = "")


  # Call to export records with a pipe delimiter.

  Records <- makeApiCall(rcon = rcon,
                         body = list(content = "record",
                                     format = "csv",
                                     returnFormat = "csv",
                                     type = "flat",
                                     csvDelimiter = "|"))
  Records <- read.csv(text = as.character(Records),
                      stringsAsFactors = FALSE,
                      na.strings = "",
                      sep = "|")


  # Call to export records created/modified after 25 Dec 2022 14:00.

  Records <- makeApiCall(rcon = rcon,
                         body = list(content = "record",
                                     format = "csv",
                                     returnFormat = "csv",
                                     type = "flat",
                                     dateRangeBegin = "2022-12-25 14:00:00"))

  Records <- read.csv(text = as.character(Records),
                      stringsAsFactors = FALSE,
                      na.strings = "")


}

}
