% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allocationTable.R
\name{allocationTable}
\alias{allocationTable}
\alias{allocationTable.redcapApiConnection}
\alias{allocationTable_offline}
\title{Generate Allocation Tables for the Randomization Module}
\usage{
allocationTable(
  rcon,
  random,
  strata = NULL,
  group = NULL,
  dag.id = NULL,
  replicates,
  block.size,
  block.size.shift = 0,
  seed.dev = NULL,
  seed.prod = NULL,
  weights = NULL,
  ...
)

\method{allocationTable}{redcapApiConnection}(
  rcon,
  random,
  strata = NULL,
  group = NULL,
  dag.id = NULL,
  replicates,
  block.size,
  block.size.shift = 0,
  seed.dev = NULL,
  seed.prod = NULL,
  weights = c(1, 1),
  ...
)

allocationTable_offline(
  meta_data,
  random,
  strata = NULL,
  group = NULL,
  dag.id = NULL,
  replicates,
  block.size,
  block.size.shift = 0,
  seed.dev = NULL,
  seed.prod = NULL,
  weights = c(1, 1),
  ...
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{random}{\code{character(1)}. The field name to be randomized.}

\item{strata}{\code{character}. Field names by which to stratify the randomization.}

\item{group}{\code{character(1)}. A field name giving a group by which randomization should be
stratified.  This could also be listed in \code{strata}, but the argument
is provided to remain consistent with the REDCap user interface.}

\item{dag.id}{\code{integerish}. Data Access Group IDs.}

\item{replicates}{\code{integerish(1)}. The number of randomizations to perform
within each stratum}

\item{block.size}{\code{integerish}. Block size for the randomization.  Blocking is recommended
to ensure balanced groups throughout the randomization.  This may be a vector
to indicate variable block sizes throughout the randomization.}

\item{block.size.shift}{\code{numeric} on the interval \verb{[0, 1]}.
A vector the same length as \code{block.size} where the
first element is 0.  This controls when the block size changes as a proportion
of the total sample size.  When \code{block.size=c(8, 4, 2)} and
\code{block.size.shift = c(0, .5, .9)}, the first half of the randomization
is performed in blocks of 8, then the next 40 percent of the randomization
is performed in blocks of 4, with the last ten percent performed in blocks
of 2.}

\item{seed.dev}{\code{integerish}. At least one value is required.  If only one value is given,
it will be converted to a vector with length equal to the number of strata.
Values will be incremented by 100 to provide independent randomizations.
This may also have length equal to the number of strata.}

\item{seed.prod}{\code{integerish}. Same as \code{seed.dev}, but used to seed the production
allocation.  No pairwise elements of \code{seed.dev} and \code{seed.prod}
may be equal.  This guarantees that the two randomization schemes are
unique.}

\item{weights}{An optional vector giving the sampling weights for each of the randomization
groups.  There must be one number for each level of the randomization variable.  If named,
the names must match the group labels.  If unnamed, the group labels will be assigned in the
same order they appear in the data dictionary.  The weights will be normalized, so they do
not need to sum to 1.0.  In other words, \code{weights=c(3, 1)} can indicate a 3:1 sampling
ratio.}

\item{...}{Arguments to pass to other methods}

\item{meta_data}{\code{character(1)}. For the offline method, a text string
giving the location of the data dictionary downloaded from REDCap.}
}
\value{
Returns a list with the elements\tabular{ll}{
    \tab  \cr
   \code{dev_allocation} \tab \code{data.frame} with the randomization allocations for the development environment. \cr
   \code{prod_allocation} \tab \code{data.frame} with the randomization allocations for the production environment. \cr
   \code{dev_seed} \tab The random seed values for the development environment. \cr
   \code{prod_seed} \tab The random seed values for the production environment. \cr
   \code{blocks} \tab Blocking scheme used to generate the randomization. \cr
   \code{weights} \tab Weighting scheme for the randomization. \cr
}
}
\description{
These methods enable the user to generate allocation tables
for the REDCap randomization module. Randomization may be stratified by other
(categorical) variables in the data set as well as by Data
Access Group. Additionally, randomization may be blocked
to ensure balanced groups throughout the allocation
}
\details{
Each element in \code{block.size} must be a multiple of the number of
groups in the randomized variable.

The 'offline' version of the function operates on the data dictionary file
downloaded from REDCap.  This is made available for instances where the
API cannot be accessed for some reason (such as waiting for API approval
from the REDCap administrator).

The value of \code{replicates} controls how many allocations are generated.  It
is possible to get slightly more replicates than requested if your blocking design
cannot exactly match replicates.  For example, if the users asks for 30 replicates in
blocks of 8, a warning will be printed and 32 replicates will be returned in the
randomization table.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
allocationTable(rcon, 
                random = "treatment_assignment", 
                strata = c("demographic_group", "hospital_group"), 
                replicates = 12, 
                block.size = 4, 
                seed.dev = 12345, 
                seed.prod = 54321)
}

}
