% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreativeSetService.R
\name{dfp_getCreativeSetsByStatement}
\alias{dfp_getCreativeSetsByStatement}
\title{getCreativeSetsByStatement}
\usage{
dfp_getCreativeSetsByStatement(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getCreativeSetsByStatementResponse
}
\description{
Gets a CreativeSetPage of CreativeSet objects that satisfy the given Statement query. The following fields are supported for filtering: 
\itemize{
  \item{id}
  \item{name}
  \item{masterCreativeId}
  \item{lastModifiedDateTime}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getCreativeSetsByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/CreativeSetService#getCreativeSetsByStatement}{Google Documentation for getCreativeSetsByStatement}
}
