% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrd_power.R
\name{mrd_power}
\alias{mrd_power}
\title{Power Analysis of Multivariate Regression Discontinuity}
\usage{
mrd_power(
  num.rep = 100,
  sample.size = 100,
  x1.dist = "normal",
  x1.para = c(0, 1),
  x2.dist = "normal",
  x2.para = c(0, 1),
  x1.cut = 0,
  x2.cut = 0,
  x1.fuzzy = c(0, 0),
  x2.fuzzy = c(0, 0),
  x1.design = NULL,
  x2.design = NULL,
  coeff = c(0.1, 0.5, 0.5, 1, rep(0.1, 9)),
  eta.sq = 0.5,
  alpha.list = c(0.001, 0.01, 0.05)
)
}
\arguments{
\item{num.rep}{A non-negative integer specifying the number of repetitions used to calculate the empirical power. The default is 100.}

\item{sample.size}{A non-negative integer specifying the number of observations in each sample. The default is 100.}

\item{x1.dist}{A string specifying the distribution of the first assignment variable, \code{x1}.
Options are \code{"normal"} and  \code{"uniform"}. The default is the \code{"normal"} distribution.}

\item{x1.para}{A numeric vector of length 2 specifying parameters of the distribution of the first assignment variable, \code{x1}.
If \code{x1.dist} is \code{"normal"}, then \code{x1.para} includes the
mean and standard deviation of the normal distribution.
If \code{x1.dist} is \code{"uniform"}, then \code{x1.para} includes the 
upper and lower boundaries of the uniform distribution. The default is \code{c(0,1)}.}

\item{x2.dist}{A string specifying the distribution of the second assignment variable, \code{x2}.
Options are \code{"normal"} and  \code{"uniform"}. The default is the \code{"normal"} distribution.}

\item{x2.para}{A numeric vector of length 2 specifying parameters of the distribution of the second assignment variable, \code{x2}.
If \code{x2.dist} is \code{"normal"}, then \code{x2.para} includes the
mean and standard deviation of the normal distribution.
If \code{x2.dist} is \code{"uniform"}, then \code{x2.para} includes the 
upper and lower boundaries of the uniform distribution. The default is \code{c(0,1)}.}

\item{x1.cut}{A numeric value containing the cutpoint at which assignment to the treatment is determined for the first assignment variable, \code{x1}. The default is 0.}

\item{x2.cut}{A numeric value containing the cutpoint at which assignment to the treatment is determined for the second assignment variable, \code{x2}. The default is 0.}

\item{x1.fuzzy}{A numeric vector of length 2 specifying the probabilities to be
assigned to the control condition, in terms of the first
assignment variable, \code{x1}, for individuals in the treatment based on the cutoff, 
and to treatment for individuals in the control condition based on the cutoff.
For a sharp design, both entries are 0. 
For a fuzzy design, the first entry is the probability to be assigned to 
control for individuals above the cutpoint, and the second entry is the 
probability to be assigned to treatment for individuals below the cutpoint.
The default is \code{c(0,0)}, indicating a sharp design.}

\item{x2.fuzzy}{A numeric vector of length 2 specifying the probabilities to be assigned to the control, in terms of the second
assignment variable, \code{x2}, for individuals in the treatment based on the cutoff, 
and to treatment for individuals in the control based on the cutoff.
For a sharp design, both entries are 0. 
For a fuzzy design, the first entry is the probability to be assigned to 
control for individuals above the cutpoint, and the second entry is the 
probability to be assigned to treatment for individuals below the cutpoint.
The default is \code{c(0,0)}, indicating a sharp design.}

\item{x1.design}{A string specifying the treatment option according to design for \code{x1}. Options are
\code{"g"} (treatment is assigned if \code{x1} is greater than its cutoff),
\code{"geq"} (treatment is assigned if \code{x1} is greater than or equal to its cutoff),
\code{"l"} (treatment is assigned if \code{x1} is less than its cutoff),
and \code{"leq"} (treatment is assigned if \code{x1} is less than or equal to its cutoff).}

\item{x2.design}{A string specifying the treatment option according to design for \code{x2}. Options are
\code{"g"} (treatment is assigned if \code{x2} is greater than its cutoff),
\code{"geq"} (treatment is assigned if \code{x2} is greater than or equal to its cutoff),
\code{"l"} (treatment is assigned if \code{x2} is less than its cutoff),
and \code{"leq"} (treatment is assigned if \code{x2} is less than or equal to its cutoff).}

\item{coeff}{A numeric vector specifying coefficients of variables in the linear model to generate data. Coefficients are in the following order:
\itemize{
\item{The 1st entry is the intercept.}
\item{The 2nd entry is the slope of treatment 1, i.e. treatment effect 1.}
\item{The 3rd entry is the slope of treatment 2, i.e. treatment effect 2.}
\item{The 4th entry is the slope of treatment, i.e. treatment effect.}
\item{The 5th entry is the slope of assignment 1.}
\item{The 6th entry is the slope of assignment 2.}
\item{The 7th entry is the slope of interaction between assignment 1 and assignment 2.}
\item{The 8th entry is the slope of interaction between treatment 1 and assignment 1.}
\item{The 9th entry is the slope of interaction between treatment 2 and assignment 1.}
\item{The 10th entry is the slope of interaction between treatment 1 and assignment 2.}
\item{The 11th entry is the slope of interaction between treatment 2 and assignment 2.}
\item{The 12th entry is the slope of interaction between treatment 1, assignment 1 and assignment 2.}
\item{The 13th entry is the slope of interaction between treatment 2, assignment 1 and assignment 2.}
}
The default is \code{c(0.1, 0.5, 0.5, 1, rep(0.1, 9))}.}

\item{eta.sq}{A numeric value specifying the expected partial eta-squared of the linear model with respect to the 
treatment itself. It is used to control the variance of noise in the linear model. The default is 0.50.}

\item{alpha.list}{A numeric vector containing significance levels (between 0 and 1) used to calculate the empirical alpha.
The default is \code{c(0.001, 0.01, anad 0.05)}.}
}
\value{
\code{mrd_power} returns an object of \link{class} 
  "\code{mrdp}" containing the number of successful iterations,
  mean, variance, and power (with \code{alpha} of 0.001, 0.01, and 0.05)
  for six estimators. The function \code{summary}
  is used to obtain and print a summary of the power analysis.
  The six estimators are as follows:
  \itemize{
  \item{The 1st estimator, \code{Linear}, provides results of the linear regression estimator 
  of combined RD using the centering approach.}
  \item{The 2nd estimator, \code{Opt}, provides results of the local linear regression estimator
  of combined RD using the centering approach, 
  with the optimal bandwidth in the Imbens and Kalyanaraman (2012) paper.}
  \item{The 3rd estimator, \code{Linear}, provides results of the linear regression estimator 
  of separate RD in terms of \code{x1} using the univariate approach.}
  \item{The 4th estimator, \code{Opt}, provides results of the local linear regression estimator
  of separate RD in terms of \code{x1} using the univariate approach, 
  with the optimal bandwidth in the Imbens and Kalyanaraman (2012) paper.}
  \item{The 5th estimator, \code{Linear}, provides results of the linear regression estimator 
  of separate RD in terms of \code{x2} using the univariate approach.}
  \item{The 6th estimator, \code{Opt}, provides results of the local linear regression estimator
  of separate RD in terms of \code{x2} using the univariate approach, 
  with the optimal bandwidth in the Imbens and Kalyanaraman (2012) paper.}
  }
}
\description{
\code{mrd_power} computes the empirical probability that a resulting parameter
estimate of the MRD is significant,
i.e. the empirical power (1 - beta).
}
\examples{
\dontrun{
summary(mrd_power(x1.design = "l", x2.design = "l"))
summary(mrd_power(x1.dist = "uniform", x1.cut = 0.5,
                  x1.design = "l", x2.design = "l"))
summary(mrd_power(x1.fuzzy = c(0.1, 0.1), x1.design = "l", x2.design = "l"))
}
}
\references{
Imbens, G., Kalyanaraman, K. (2012). 
  Optimal bandwidth choice for the regression discontinuity estimator. 
  The Review of Economic Studies, 79(3), 933-959.
  \url{https://academic.oup.com/restud/article/79/3/933/1533189}.
}
