% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_advanced_search.R
\name{core_advanced_search}
\alias{core_advanced_search}
\alias{core_query}
\title{Advanced Search CORE}
\usage{
core_advanced_search(
  ...,
  page = 1,
  limit = 10,
  key = NULL,
  parse = TRUE,
  .list = list()
)

core_query(..., op = "AND")
}
\arguments{
\item{...}{for \code{core_query()}, query fields, see Details. for
\code{core_advanced_search()} any number of queries, results of calling
\code{core_query()}. Required. See Details.}

\item{page}{(character) page number (default: 1), optional}

\item{limit}{(character) records to return (default: 10, minimum: 10,
maximum: 100), optional}

\item{key}{A CORE API key. Get one at
\url{https://core.ac.uk/api-keys/register}. Once you have the key,
you can pass it into this parameter, or as a much better option,
store your key as an environment variable with the name
\code{CORE_KEY} or an R option as \code{core_key}. See \code{?Startup}
for how to work with env vars and R options}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{.list}{alternative to passing \code{core_query()} calls to \code{...};
just create a list of them and pass to this parameter; easier for
programming with}

\item{op}{(character) operator to combine multiple fields. options:
\code{AND}, \code{OR}}
}
\value{
data.frame with the following columns:
\itemize{
\item \code{status}: string, which will be 'OK' or 'Not found' or
'Too many queries' or 'Missing parameter' or 'Invalid parameter' or
'Parameter out of bounds'
\item \code{totalHits}: integer, Total number of items matching the search criteria
\item \code{data}: list, a list of relevant resource
}
}
\description{
Advanced Search CORE
}
\details{
\code{query} should be one or more calls to \code{core_query()},
(at least one is required):
\itemize{
\item \code{title}
\item \code{description}
\item \code{fullText}
\item \code{authors}
\item \code{publisher}: string, to be used as an absolute match against the
publisher name metadata field
\item \code{repositories.id}: repository id
\item \code{repositories.name}: repository name
\item \code{doi}: string, to be used as an absolute match against the repository
name metadata field (all other fields will be ignored if included)
\item \code{oai}
\item \code{identifiers}
\item \code{language.name}: string, to filter against languages specified in
https://en.wikipedia.org/wiki/ISO_639-1
\item \code{year}: year to filter to
}

\code{core_advanced_search} does the HTTP request and parses, while
\code{core_advanced_search_} just does the HTTP request, gives back JSON as a
character string
}
\examples{
\dontrun{
## compose queries
core_query(title="psychology", year=2014)
core_query(title="psychology", year=2014, op="OR")
core_query(identifiers='"oai:aura.abdn.ac.uk:2164/3837"',
  identifiers='"oai:aura.abdn.ac.uk:2164/3843"', op="OR")

## do actual searches
core_advanced_search(
  core_query(identifiers='"oai:aura.abdn.ac.uk:2164/3837"',
    identifiers='"oai:aura.abdn.ac.uk:2164/3843"', op="OR")
)

res <- core_advanced_search(
  core_query(title="psychology"),
  core_query(doi='"10.1186/1471-2458-6-309"'),
  core_query(language.name="german")
)
res
}
}
\references{
https://core.ac.uk/docs/#!/all/searchBatch
}
