% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_articles_history.R
\name{core_articles_history}
\alias{core_articles_history}
\alias{core_articles_history_}
\title{Get article history}
\usage{
core_articles_history(id, page = 1, limit = 10, key = NULL,
  parse = TRUE, ...)

core_articles_history_(id, page = 1, limit = 10, key = NULL, ...)
}
\arguments{
\item{id}{(integer) CORE ID of the article that needs to be fetched.
One or more. Required}

\item{page}{(character) page number (default: 1), optional}

\item{limit}{(character) records to return (default: 10, minimum: 10),
optional}

\item{key}{A CORE API key. Get one at
\url{https://core.ac.uk/api-keys/register}. Once you have the key,
you can pass it into this parameter, or as a much better option,
store your key as an environment variable with the name
\code{CORE_KEY} or an R option as \code{core_key}. See \code{?Startup}
for how to work with env vars and R options}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\value{
\code{core_articles_history_} returns a JSON string on success.
\code{core_articles_history} returns a list (equal to \code{id} length) where each
element is a list of length two with elements for data and status of
the request; on failure the data slot is NULL.
}
\description{
Get article history
}
\details{
\code{core_articles_history} does the HTTP request and parses,
while \code{core_articles_history_} just does the HTTP request, gives back JSON
as a character string
}
\examples{
\dontrun{
core_articles_history(id = 21132995)

ids <- c(20955435, 21132995, 21813171, 22815670, 14045109, 23828884,
   23465055, 23831838, 23923390, 22559733)
res <- core_articles_history(ids)
vapply(res, function(z) z$data$datetime[1], "")

# just http request, get text back
core_articles_history_(21132995)
}
}
\references{
\url{https://core.ac.uk/docs/#!/articles/getArticleHistoryByCoreId}
}
