% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdo-ymoneq.R, R/cdo-ymonge.R, R/cdo-ymongt.R,
%   R/cdo-ymonle.R, R/cdo-ymonlt.R, R/cdo-ymonne.R, R/family-ymoncomp.R
\name{cdo_ymoneq}
\alias{cdo_ymoneq}
\alias{cdo_ymonge}
\alias{cdo_ymongt}
\alias{cdo_ymonle}
\alias{cdo_ymonlt}
\alias{cdo_ymonne}
\alias{ymoncomp}
\title{Multiyear monthly comparison}
\usage{
cdo_ymoneq(ifile1, ifile2, ofile = NULL)

cdo_ymonge(ifile1, ifile2, ofile = NULL)

cdo_ymongt(ifile1, ifile2, ofile = NULL)

cdo_ymonle(ifile1, ifile2, ofile = NULL)

cdo_ymonlt(ifile1, ifile2, ofile = NULL)

cdo_ymonne(ifile1, ifile2, ofile = NULL)
}
\arguments{
\item{ifile1, ifile2}{Strings with the path to the input files.}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This module performs compaisons of a time series and one timestep with the same month of year. For each field in infile1 the corresponding field of the timestep in infile2 with the same month of year is used. The resulting field is a mask containing 1 if the comparison is true and 0 if not. The type of comparison depends on the chosen operator. The input files need to have the same structure with the same variables. Usually infile2 is generated by an operator of the module YMONSTAT.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ymoneq  Compare time series with Equal
        Compares whether a time series is equal to a multi-year monthly time series.
ymonne  Compare time series with NotEqual
        Compares whether a time series is not equal to a multi-year monthly time series.
ymonle  Compare time series with LessEqual
        Compares whether a time series is less than or equal to a multi-year monthly time series.
ymonlt  Compares if time series with LessThan
        Compares whether a time series is less than a multi-year monthly time series.
ymonge  Compares if time series with GreaterEqual
        Compares whether a time series is greater than or equal to a multi-year monthly time series.
ymongt  Compares if time series with GreaterThan
        Compares whether a time series is greater than a multi-year monthly time series.
}\if{html}{\out{</div>}}
}
