% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_manual_input.R
\name{read_manual_input}
\alias{read_manual_input}
\title{Read manual input}
\usage{
read_manual_input(path_to_HSP_project, img_name)
}
\arguments{
\item{path_to_HSP_project}{Character vector of length one. Path to the HSP
project folder. For instance,
"C:/Users/johndoe/Documents/HSP/Projects/my_prj/".}

\item{img_name}{Character vector of length one. For instance, "DSCN6342.pgm"
or "DSCN6342". See details.}
}
\value{
A list of numeric vectors named \emph{weight}, \emph{max_points},
\emph{angle}, \emph{point_radius}, \emph{sun_coord}, \emph{sky_points} and
\emph{zenith_dn.}
}
\description{
Read manual input stored in an HSP project.
}
\details{
Refer to the Details section of function
\code{\link[=write_sky_points]{write_sky_points()}}.
}
\seealso{
Other HSP Functions: 
\code{\link{read_opt_sky_coef}()},
\code{\link{row_col_from_zenith_azimuth}()},
\code{\link{write_sky_points}()},
\code{\link{write_sun_coord}()},
\code{\link{zenith_azimuth_from_row_col}()}
}
\concept{HSP Functions}
