% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_functions.R
\name{rba_uniprot_ptm}
\alias{rba_uniprot_ptm}
\title{Get Post-Translational Modification of UniProt Protein (Deprecated)}
\usage{
rba_uniprot_ptm(accession, ...)
}
\arguments{
\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list containing the post-translational modification features of
your supplied UniProt protein's sequence.
}
\description{
This function is Deprecated. Please use
  \code{\link{rba_uniprot_proteomics_ptm}} instead.\cr
UniProt maps post-translational modification features from different sources
  to the proteins'  sequences. Using this function, you can retrieve all
  the post-translational modification features that has been map to a given
  UniProt protein's sequence.
}
\details{
see also:
  \href{https://www.uniprot.org/help/ptm_processing_section}{PTM /
  Processing section in UniProtKB}
}
\section{Corresponding API Resources}{

 "GET https://www.ebi.ac.uk/proteins/api/proteomics-ptm/\{accession\}"
}

\examples{
\dontrun{
#Deprecated
rba_uniprot_ptm(accession = "P04234")
}

}
\references{
\itemize{
  \item The UniProt Consortium, UniProt: the universal protein
  knowledgebase in 2021, Nucleic Acids Research, Volume 49, Issue D1,
  8 January 2021, Pages D480–D489, https://doi.org/10.1093/nar/gkaa1100
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "Deprecated functions": 
\code{\link{rba_uniprot_proteomics}()},
\code{\link{rba_uniprot_proteomics_search}()},
\code{\link{rba_uniprot_ptm_search}()}
}
\concept{"Deprecated functions"}
