// Generated by rstantools.  Do not edit by hand.

/*
    rater is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rater is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rater.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_grouped_data_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'grouped_data', line 11, column 2 to column 16)",
                                                      " (in 'grouped_data', line 12, column 2 to column 31)",
                                                      " (in 'grouped_data', line 15, column 2 to column 29)",
                                                      " (in 'grouped_data', line 18, column 4 to column 25)",
                                                      " (in 'grouped_data', line 21, column 9 to column 69)",
                                                      " (in 'grouped_data', line 20, column 6 to line 21, column 69)",
                                                      " (in 'grouped_data', line 19, column 4 to line 21, column 69)",
                                                      " (in 'grouped_data', line 17, column 17 to line 22, column 3)",
                                                      " (in 'grouped_data', line 17, column 2 to line 22, column 3)",
                                                      " (in 'grouped_data', line 26, column 2 to column 24)",
                                                      " (in 'grouped_data', line 29, column 6 to column 42)",
                                                      " (in 'grouped_data', line 28, column 19 to line 30, column 5)",
                                                      " (in 'grouped_data', line 28, column 4 to line 30, column 5)",
                                                      " (in 'grouped_data', line 27, column 17 to line 31, column 3)",
                                                      " (in 'grouped_data', line 27, column 2 to line 31, column 3)",
                                                      " (in 'grouped_data', line 34, column 4 to column 49)",
                                                      " (in 'grouped_data', line 33, column 17 to line 35, column 3)",
                                                      " (in 'grouped_data', line 33, column 2 to line 35, column 3)",
                                                      " (in 'grouped_data', line 2, column 2 to column 17)",
                                                      " (in 'grouped_data', line 3, column 2 to column 17)",
                                                      " (in 'grouped_data', line 4, column 2 to column 17)",
                                                      " (in 'grouped_data', line 5, column 8 to column 9)",
                                                      " (in 'grouped_data', line 5, column 2 to column 22)",
                                                      " (in 'grouped_data', line 6, column 8 to column 9)",
                                                      " (in 'grouped_data', line 6, column 11 to column 12)",
                                                      " (in 'grouped_data', line 6, column 2 to column 39)",
                                                      " (in 'grouped_data', line 7, column 18 to column 19)",
                                                      " (in 'grouped_data', line 7, column 2 to column 27)",
                                                      " (in 'grouped_data', line 8, column 8 to column 9)",
                                                      " (in 'grouped_data', line 8, column 11 to column 12)",
                                                      " (in 'grouped_data', line 8, column 30 to column 31)",
                                                      " (in 'grouped_data', line 8, column 2 to column 38)",
                                                      " (in 'grouped_data', line 11, column 10 to column 11)",
                                                      " (in 'grouped_data', line 12, column 8 to column 9)",
                                                      " (in 'grouped_data', line 12, column 11 to column 12)",
                                                      " (in 'grouped_data', line 12, column 22 to column 23)",
                                                      " (in 'grouped_data', line 15, column 8 to column 9)",
                                                      " (in 'grouped_data', line 15, column 18 to column 19)"};
#include <stan_meta_header.hpp>
class model_grouped_data final : public model_base_crtp<model_grouped_data> {
private:
  int N;
  int K;
  int J;
  std::vector<double> tally;
  std::vector<std::vector<int>> key;
  Eigen::Matrix<double, -1, 1> alpha;
  std::vector<std::vector<Eigen::Matrix<double, -1, 1>>> beta;
 
public:
  ~model_grouped_data() { }
  
  inline std::string model_name() const final { return "model_grouped_data"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_grouped_data(stan::io::var_context& context__,
                     unsigned int random_seed__ = 0,
                     std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_grouped_data_namespace::model_grouped_data";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 19;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 19;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 19;
      current_statement__ = 19;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 20;
      context__.validate_dims("data initialization","K","int",
          context__.to_vec());
      K = std::numeric_limits<int>::min();
      
      current_statement__ = 20;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 20;
      current_statement__ = 20;
      check_greater_or_equal(function__, "K", K, 1);
      current_statement__ = 21;
      context__.validate_dims("data initialization","J","int",
          context__.to_vec());
      J = std::numeric_limits<int>::min();
      
      current_statement__ = 21;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 21;
      current_statement__ = 21;
      check_greater_or_equal(function__, "J", J, 1);
      current_statement__ = 22;
      validate_non_negative_index("tally", "N", N);
      current_statement__ = 23;
      context__.validate_dims("data initialization","tally","double",
          context__.to_vec(N));
      tally = std::vector<double>(N, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 23;
      assign(tally, nil_index_list(), context__.vals_r("tally"),
        "assigning variable tally");
      current_statement__ = 24;
      validate_non_negative_index("key", "N", N);
      current_statement__ = 25;
      validate_non_negative_index("key", "J", J);
      current_statement__ = 26;
      context__.validate_dims("data initialization","key","int",
          context__.to_vec(N, J));
      key = std::vector<std::vector<int>>(N, std::vector<int>(J, std::numeric_limits<int>::min()));
      
      {
        std::vector<int> key_flat__;
        current_statement__ = 26;
        assign(key_flat__, nil_index_list(), context__.vals_i("key"),
          "assigning variable key_flat__");
        current_statement__ = 26;
        pos__ = 1;
        current_statement__ = 26;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 26;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 26;
            assign(key,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              key_flat__[(pos__ - 1)], "assigning variable key");
            current_statement__ = 26;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 26;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 26;
        for (int sym2__ = 1; sym2__ <= J; ++sym2__) {
          current_statement__ = 26;
          current_statement__ = 26;
          check_greater_or_equal(function__, "key[sym1__, sym2__]",
                                 key[(sym1__ - 1)][(sym2__ - 1)], 1);}}
      current_statement__ = 26;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 26;
        for (int sym2__ = 1; sym2__ <= J; ++sym2__) {
          current_statement__ = 26;
          current_statement__ = 26;
          check_less_or_equal(function__, "key[sym1__, sym2__]",
                              key[(sym1__ - 1)][(sym2__ - 1)], K);}}
      current_statement__ = 27;
      validate_non_negative_index("alpha", "K", K);
      current_statement__ = 28;
      context__.validate_dims("data initialization","alpha","double",
          context__.to_vec(K));
      alpha = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> alpha_flat__;
        current_statement__ = 28;
        assign(alpha_flat__, nil_index_list(), context__.vals_r("alpha"),
          "assigning variable alpha_flat__");
        current_statement__ = 28;
        pos__ = 1;
        current_statement__ = 28;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 28;
          assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
            alpha_flat__[(pos__ - 1)], "assigning variable alpha");
          current_statement__ = 28;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 28;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 28;
        current_statement__ = 28;
        check_greater_or_equal(function__, "alpha[sym1__]",
                               alpha[(sym1__ - 1)], 0);}
      current_statement__ = 29;
      validate_non_negative_index("beta", "J", J);
      current_statement__ = 30;
      validate_non_negative_index("beta", "K", K);
      current_statement__ = 31;
      validate_non_negative_index("beta", "K", K);
      current_statement__ = 32;
      context__.validate_dims("data initialization","beta","double",
          context__.to_vec(J, K, K));
      beta = std::vector<std::vector<Eigen::Matrix<double, -1, 1>>>(J, std::vector<Eigen::Matrix<double, -1, 1>>(K, Eigen::Matrix<double, -1, 1>(K)));
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 32;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 32;
        pos__ = 1;
        current_statement__ = 32;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 32;
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            current_statement__ = 32;
            for (int sym3__ = 1; sym3__ <= J; ++sym3__) {
              current_statement__ = 32;
              assign(beta,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                beta_flat__[(pos__ - 1)], "assigning variable beta");
              current_statement__ = 32;
              pos__ = (pos__ + 1);}}}
      }
      current_statement__ = 32;
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        current_statement__ = 32;
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          current_statement__ = 32;
          for (int sym3__ = 1; sym3__ <= K; ++sym3__) {
            current_statement__ = 32;
            current_statement__ = 32;
            check_greater_or_equal(function__,
                                   "beta[sym1__, sym2__, sym3__]",
                                   beta[(sym1__ - 1)][(sym2__ - 1)][(sym3__ -
                                                                    1)], 0);}
        }}
      current_statement__ = 33;
      validate_positive_index("pi", "K", K);
      current_statement__ = 34;
      validate_non_negative_index("theta", "J", J);
      current_statement__ = 35;
      validate_non_negative_index("theta", "K", K);
      current_statement__ = 36;
      validate_positive_index("theta", "K", K);
      current_statement__ = 37;
      validate_non_negative_index("log_p_z", "N", N);
      current_statement__ = 38;
      validate_non_negative_index("log_p_z", "K", K);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += (K - 1);
      num_params_r__ += J * K * (K - 1);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_grouped_data_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> pi;
      pi = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(pi, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> pi_in__;
      pi_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>((K - 1));
      stan::math::fill(pi_in__, DUMMY_VAR__);
      
      current_statement__ = 1;
      pi_in__ = in__.vector((K - 1));
      current_statement__ = 1;
      if (jacobian__) {
        current_statement__ = 1;
        assign(pi, nil_index_list(),
          stan::math::simplex_constrain(pi_in__, lp__),
          "assigning variable pi");
      } else {
        current_statement__ = 1;
        assign(pi, nil_index_list(), stan::math::simplex_constrain(pi_in__),
          "assigning variable pi");
      }
      std::vector<std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>> theta;
      theta = std::vector<std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>>(J, std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(K, Eigen::Matrix<local_scalar_t__, -1, 1>(K)));
      stan::math::fill(theta, DUMMY_VAR__);
      
      std::vector<std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>> theta_in__;
      theta_in__ = std::vector<std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>>(J, std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(K, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (K - 1))));
      stan::math::fill(theta_in__, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          current_statement__ = 2;
          assign(theta_in__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            in__.vector((K - 1)), "assigning variable theta_in__");}}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          current_statement__ = 2;
          if (jacobian__) {
            current_statement__ = 2;
            assign(theta,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::simplex_constrain(
                theta_in__[(sym1__ - 1)][(sym2__ - 1)], lp__),
              "assigning variable theta");
          } else {
            current_statement__ = 2;
            assign(theta,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::simplex_constrain(
                theta_in__[(sym1__ - 1)][(sym2__ - 1)]),
              "assigning variable theta");
          }}}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> log_p_z;
      log_p_z = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(N, Eigen::Matrix<local_scalar_t__, -1, 1>(K));
      stan::math::fill(log_p_z, DUMMY_VAR__);
      
      current_statement__ = 9;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 4;
        assign(log_p_z, cons_list(index_uni(i), nil_index_list()),
          stan::math::log(pi), "assigning variable log_p_z");
        current_statement__ = 7;
        for (int j = 1; j <= J; ++j) {
          current_statement__ = 6;
          for (int k = 1; k <= K; ++k) {
            current_statement__ = 5;
            assign(log_p_z,
              cons_list(index_uni(i),
                cons_list(index_uni(k), nil_index_list())),
              (log_p_z[(i - 1)][(k - 1)] +
                stan::math::log(
                  theta[(j - 1)][(k - 1)][(key[(i - 1)][(j - 1)] - 1)])),
              "assigning variable log_p_z");}}}
      {
        current_statement__ = 10;
        lp_accum__.add(dirichlet_lpdf<propto__>(pi, alpha));
        current_statement__ = 15;
        for (int j = 1; j <= J; ++j) {
          current_statement__ = 13;
          for (int k = 1; k <= K; ++k) {
            current_statement__ = 11;
            lp_accum__.add(
              dirichlet_lpdf<propto__>(theta[(j - 1)][(k - 1)],
                beta[(j - 1)][(k - 1)]));}}
        current_statement__ = 18;
        for (int i = 1; i <= N; ++i) {
          current_statement__ = 16;
          lp_accum__.add((tally[(i - 1)] * log_sum_exp(log_p_z[(i - 1)])));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_grouped_data_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> pi;
      pi = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(pi, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> pi_in__;
      pi_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>((K - 1));
      stan::math::fill(pi_in__, DUMMY_VAR__);
      
      current_statement__ = 1;
      pi_in__ = in__.vector((K - 1));
      current_statement__ = 1;
      assign(pi, nil_index_list(), stan::math::simplex_constrain(pi_in__),
        "assigning variable pi");
      std::vector<std::vector<Eigen::Matrix<double, -1, 1>>> theta;
      theta = std::vector<std::vector<Eigen::Matrix<double, -1, 1>>>(J, std::vector<Eigen::Matrix<double, -1, 1>>(K, Eigen::Matrix<double, -1, 1>(K)));
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>> theta_in__;
      theta_in__ = std::vector<std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>>(J, std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(K, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (K - 1))));
      stan::math::fill(theta_in__, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          current_statement__ = 2;
          assign(theta_in__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            in__.vector((K - 1)), "assigning variable theta_in__");}}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          current_statement__ = 2;
          assign(theta,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::simplex_constrain(
              theta_in__[(sym1__ - 1)][(sym2__ - 1)]),
            "assigning variable theta");}}
      std::vector<Eigen::Matrix<double, -1, 1>> log_p_z;
      log_p_z = std::vector<Eigen::Matrix<double, -1, 1>>(N, Eigen::Matrix<double, -1, 1>(K));
      stan::math::fill(log_p_z, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(pi[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= J; ++sym3__) {
            vars__.emplace_back(
              theta[(sym3__ - 1)][(sym2__ - 1)][(sym1__ - 1)]);}}}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 9;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 4;
        assign(log_p_z, cons_list(index_uni(i), nil_index_list()),
          stan::math::log(pi), "assigning variable log_p_z");
        current_statement__ = 7;
        for (int j = 1; j <= J; ++j) {
          current_statement__ = 6;
          for (int k = 1; k <= K; ++k) {
            current_statement__ = 5;
            assign(log_p_z,
              cons_list(index_uni(i),
                cons_list(index_uni(k), nil_index_list())),
              (log_p_z[(i - 1)][(k - 1)] +
                stan::math::log(
                  theta[(j - 1)][(k - 1)][(key[(i - 1)][(j - 1)] - 1)])),
              "assigning variable log_p_z");}}}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            vars__.emplace_back(log_p_z[(sym2__ - 1)][(sym1__ - 1)]);}}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> pi;
      pi = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(pi, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> pi_flat__;
        current_statement__ = 1;
        assign(pi_flat__, nil_index_list(), context__.vals_r("pi"),
          "assigning variable pi_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 1;
          assign(pi, cons_list(index_uni(sym1__), nil_index_list()),
            pi_flat__[(pos__ - 1)], "assigning variable pi");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> pi_free__;
      pi_free__ = Eigen::Matrix<double, -1, 1>((K - 1));
      stan::math::fill(pi_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(pi_free__, nil_index_list(), stan::math::simplex_free(pi),
        "assigning variable pi_free__");
      std::vector<std::vector<Eigen::Matrix<double, -1, 1>>> theta;
      theta = std::vector<std::vector<Eigen::Matrix<double, -1, 1>>>(J, std::vector<Eigen::Matrix<double, -1, 1>>(K, Eigen::Matrix<double, -1, 1>(K)));
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> theta_flat__;
        current_statement__ = 2;
        assign(theta_flat__, nil_index_list(), context__.vals_r("theta"),
          "assigning variable theta_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            current_statement__ = 2;
            for (int sym3__ = 1; sym3__ <= J; ++sym3__) {
              current_statement__ = 2;
              assign(theta,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                theta_flat__[(pos__ - 1)], "assigning variable theta");
              current_statement__ = 2;
              pos__ = (pos__ + 1);}}}
      }
      std::vector<std::vector<Eigen::Matrix<double, -1, 1>>> theta_free__;
      theta_free__ = std::vector<std::vector<Eigen::Matrix<double, -1, 1>>>(J, std::vector<Eigen::Matrix<double, -1, 1>>(K, Eigen::Matrix<double, -1, 1>(
        (K - 1))));
      stan::math::fill(theta_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          current_statement__ = 2;
          assign(theta_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::simplex_free(theta[(sym1__ - 1)][(sym2__ - 1)]),
            "assigning variable theta_free__");}}
      for (int sym1__ = 1; sym1__ <= (K - 1); ++sym1__) {
        vars__.emplace_back(pi_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= (K - 1); ++sym3__) {
            vars__.emplace_back(
              theta_free__[(sym1__ - 1)][(sym2__ - 1)][(sym3__ - 1)]);}}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("pi");
    names__.emplace_back("theta");
    names__.emplace_back("log_p_z");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(J),
                                             static_cast<size_t>(K),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N),
                                             static_cast<size_t>(K)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "pi" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= J; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "log_p_z" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= (K - 1); ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "pi" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= (K - 1); ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= J; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "log_p_z" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"pi\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"array\",\"length\":" << J << ",\"element_type\":{\"name\":\"array\",\"length\":" << K << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}}},\"block\":\"parameters\"},{\"name\":\"log_p_z\",\"type\":{\"name\":\"array\",\"length\":" << N << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"pi\",\"type\":{\"name\":\"vector\",\"length\":" << (K - 1) << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"array\",\"length\":" << J << ",\"element_type\":{\"name\":\"array\",\"length\":" << K << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (K - 1) << "}}},\"block\":\"parameters\"},{\"name\":\"log_p_z\",\"type\":{\"name\":\"array\",\"length\":" << N << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_grouped_data_namespace::model_grouped_data;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_grouped_data_namespace::profiles__;
}
#endif
#endif
