% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rare.group.R
\name{group.recover}
\alias{group.recover}
\title{Recover aggregated groups of leaf indices}
\usage{
group.recover(gamma, A, postorder = seq(ncol(A)))
}
\arguments{
\item{gamma}{Length-\code{nnodes} latent variable coefficients. Note that \code{\link{rarefit}}
returns \code{NA} as \code{gamma} value when \code{alpha} is zero,
in which case our problem becomes the lasso on \code{beta}.}

\item{A}{\code{nvars}-by-\code{nnodes} binary matrix encoding ancestor-descendant relationships
between leaves and nodes in the tree.}

\item{postorder}{Length-\code{nnodes} integer vector encoding post-order traversal of the tree
nodes such that \code{seq(nnodes)[postorder]} ensures a node appear after its descendants.
Default is \code{seq(nnodes)}, which gives post-order when \code{A} is generated using \code{\link{tree.matrix}}
for an \code{hclust} tree.}
}
\value{
Returns a list of recovered groups of leaf indices.
}
\description{
The function finds aggregated groups of leaf indices by traversing non-zero
\code{gamma} elements and finding descendant leaves at each \code{gamma} element. In our problem,
\code{gamma} are latent variables corresponding to tree nodes. The order
of the traversal is post-order, i.e., a node is visited after its descendants.
}
\examples{
\dontrun{
# See vignette for more details.
set.seed(100)
ts <- sample(1:length(data.rating), 400) # Train set indices
# Fit the model on train set
ourfit <- rarefit(y = data.rating[ts], X = data.dtm[ts, ], hc = data.hc, lam.min.ratio = 1e-6,
                  nlam = 20, nalpha = 10, rho = 0.01, eps1 = 1e-5, eps2 = 1e-5, maxite = 1e4)
# Cross validation
ourfit.cv <- rarefit.cv(ourfit, y = data.rating[ts], X = data.dtm[ts, ],
                        rho = 0.01, eps1 = 1e-5, eps2 = 1e-5, maxite = 1e4)
# Group recovered at optimal beta and gamma
ibest.lambda <- ourfit.cv$ibest[1]
ibest.alpha <- ourfit.cv$ibest[2]
gamma.opt <- ourfit$gamma[[ibest.alpha]][, ibest.lambda] # works if ibest.alpha > 1
groups.opt <- group.recover(gamma.opt, ourfit$A)
}

}
