% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{get_kpi}
\alias{get_kpi}
\alias{get_kpi_groups}
\alias{get_ou}
\alias{get_municipality}
\alias{get_municipality_groups}
\title{Download metadata for a specific entity from the Kolada API}
\usage{
get_kpi(
  id = NULL,
  max_results = NULL,
  cache = FALSE,
  cache_location = tempdir,
  verbose = FALSE
)

get_kpi_groups(
  id = NULL,
  cache = FALSE,
  max_results = NULL,
  cache_location = tempdir,
  verbose = FALSE
)

get_ou(
  id = NULL,
  municipality = NULL,
  max_results = NULL,
  cache = FALSE,
  cache_location = tempdir,
  verbose = FALSE
)

get_municipality(
  id = NULL,
  cache = FALSE,
  max_results = NULL,
  cache_location = tempdir,
  verbose = FALSE
)

get_municipality_groups(
  id = NULL,
  cache = FALSE,
  max_results = NULL,
  cache_location = tempdir,
  verbose = FALSE
)
}
\arguments{
\item{id}{(Optional) One or several KPI IDs}

\item{max_results}{(Optional) Specify the maximum number of results
returned by the query.}

\item{cache}{Logical. If TRUE, downloaded data are stored to the local disk
in the place specified by \code{cache_location}. If data is already present
on the local disk, this data is returned instead of downloading data from
the API.}

\item{cache_location}{Where to store and search for cached data. Can be a
path to a directory or the name of any function that returns the path to a
directory when called, like \code{\link{getwd}}. Defaults to
\code{\link{tempdir}}.}

\item{verbose}{Whether to print the call to the Kolada API as a message to
the R console.}

\item{municipality}{(Optional) A string or vector of strings containing
municipality codes. If getting OU data, you can use this parameter to narrow
the search.}
}
\value{
Returns a tibble with metadata for the specified entity. In rKolada
terminology, a table returned by e.g. \code{\link{get_kpi}} is referred to
as a \code{kpi_df} and can be passed to functions starting with "kpi" such
as \code{\link{kpi_bind_keywords}}.
}
\description{
There are five different types of metadata entities in the Kolada database:
"kpi", "kpi_groups", "municipality", "municipality_groups", and "ou". For
every entity there is a corresponding function \code{get_ENTITY} which
retrieves a table with the metadata for that entity. The \code{get_ENTITY}
functions are thin wrappers around \code{\link{get_metadata}}.
}
\examples{
# Download KPI table and store a cache copy of the results in a temporary folder
# (to actually download all available data, don't specify max_results)
kpi_df <- get_kpi(cache = TRUE, max_results = 100)

}
