% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{compose_data_query}
\alias{compose_data_query}
\title{Compose a query to fetch metadata from the Kolada API. Its use is mainly}
\usage{
compose_data_query(
  kpi = NULL,
  municipality = NULL,
  period = NULL,
  ou = NULL,
  unit_type = "municipality",
  page = NA,
  per_page = NA,
  version = "v2"
)
}
\arguments{
\item{kpi}{What kpis should be fetched? Can be a single name or a vector of
names.}

\item{municipality}{For which municipalities should data be fetched? Can be a
single name or a vector of names.}

\item{period}{For what years should data be fetched? Can be one or more
four-digit integers or character strings.}

\item{ou}{(Optional) for what Operating Units should data be fetched? Only
available for certain KPIs. Only used if \code{unit_type} is set to \code{"ou"}.}

\item{unit_type}{One of \code{"municipality"} or \code{"ou"}. Whether to
fetch data for Municipalities or Organizational Units.
Units. Defaults to \code{"municipality"}.}

\item{page}{What page to fetch. Used mainly in large queries. Fetches a page using the value of \code{"per_page"} as pagination delimiter.}

\item{per_page}{Number of results per page.}

\item{version}{Version of the API. Currently only \code{"v2"} is supported.}
}
\value{
A string containing a URL to the Kolada REST API.
}
\description{
Mainly used as a supporting function for \code{link{get_values}} but can also
be used to create a working URL to paste in your web browser.
}
