% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccm_interface.R
\name{ccm_means}
\alias{ccm_means}
\title{Take output from ccm and compute means as a function of library size.}
\usage{
ccm_means(ccm_df, FUN = mean, ...)
}
\arguments{
\item{ccm_df}{a data.frame, usually output from the \code{\link{ccm}} function}

\item{FUN}{a function that aggregates the numerical statistics (by default, uses the mean)}

\item{...}{optional arguments to FUN}
}
\value{
A data.frame with forecast statistics aggregated at each unique library
  size
}
\description{
\code{ccm_means} is a utility function to summarize output from the \code{\link{ccm}} 
function
}
\examples{
data("sardine_anchovy_sst")
anchovy_xmap_sst <- ccm(sardine_anchovy_sst, E = 3, 
  lib_column = "anchovy", target_column = "np_sst", 
  lib_sizes = seq(10, 80, by = 10), num_samples = 100)
a_xmap_t_means <- ccm_means(anchovy_xmap_sst)
}
