% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BDAT20.R
\name{BDAT20}
\alias{BDAT20}
\title{BDAT 2.0 assortment function}
\usage{
BDAT20(
  BDATArtNr,
  D1,
  H1 = 0,
  D2 = 0,
  H2 = 0,
  H,
  lX = 0,
  Hkz = 0,
  Skz = 0,
  Az = 0,
  Hsh = 0,
  Zsh = 0,
  Zab = 0,
  Sokz = 1,
  NMaxFixLng = 0,
  FixLngDef = matrix(rep(0, length(BDATArtNr) * 4), ncol = 4),
  result = "raw"
)
}
\arguments{
\item{BDATArtNr}{numeric, 1 <= spp <= 36, see \code{\link{getSpeciesCode}}}

\item{D1}{numeric, first measured diameter [cm], usually in 1.3m}

\item{H1}{numeric, height of first measured diameter [m]}

\item{D2}{numeric, second measured diameter [cm], or form parameter,
see \code{\link{buildTree}}.}

\item{H2}{H2: numeric, height of second measured diameter [m], or form
parameter, see \code{\link{buildTree}}.}

\item{H}{numeric, tree height [m]}

\item{lX}{length of unusable wood at stem foot [m], defaults to 0}

\item{Hkz}{indicator for tree top, 0 - normal (default), 1 - Wipfelbruch,
2 - Gipfelbruch}

\item{Skz}{indicator for stem type, defaults to 0, see \code{\link{buildTree}}}

\item{Az}{minimum cutting diameter over bark [cm], defaults to 0, using
tabulated data depending on DBH (not documented)}

\item{Hsh}{usable stem height, defaults to 0, i.e. 0.7*H}

\item{Zsh}{minimum cutting diameter under bark for stem wood [cm],
defaults to 0, using tabulated data depending on DBH (not documented)}

\item{Zab}{minimum cutting diameter under bark for top segment [cm],
defaults to 0, i.e. 14cm under bark.}

\item{Sokz}{type assortment calculation, 0 - no assortment,
1 - mid diameter (Mittenstärke), 2 - Heilbronner Sortierung, defaults to 1}

\item{NMaxFixLng}{number of fixed length assortments at stem foot, defaults
to 0 (no fixed length assortments, irrespective of \code{FixLngDef})}

\item{FixLngDef}{matrix of 4 * length(spp), having minimum cutting diameter,
required assortment length, absolute and relative add-on}

\item{result}{indicator about what information should be returned}
}
\value{
Using default value of \code{result}, which is 'raw', a list is
returned keeping information about the input value and produced assortments -
the unprocessed returns from the Fortran code.

See \code{\link{getAssortment}} for more details, as this function is
internally called.
}
\description{
Calculates volumes and assortments for given tree/s.
}
\examples{
BDAT20(BDATArtNr = c(1, 1), D1 = c(30, 25), H = c(25, 20)) # returns long list
BDAT20(BDATArtNr = c(1, 1), D1 = c(30, 25), H = c(25, 20), result = "Vol")
# size class
BDAT20(BDATArtNr = c(1, 1), D1 = c(30, 25), H = c(25, 20), result = "Skl")
BDAT20(
  BDATArtNr = c(1, 1), D1 = c(30, 25), H = c(25, 20), NMaxFixLng = 1,
  result = "Fix"
)
}
\seealso{
\code{\link{getAssortment}} for a more flexible function with a
more convenient english name.
}
