% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_table_content.R
\name{rtf_table_content}
\alias{rtf_table_content}
\title{Create RTF Table Body Encode}
\usage{
rtf_table_content(
  tbl,
  col_total_width = attr(tbl, "page")$col_width,
  use_border_bottom = FALSE,
  border_left = attr(tbl, "border_left"),
  border_right = attr(tbl, "border_right"),
  border_top = attr(tbl, "border_top"),
  border_bottom = attr(tbl, "border_bottom"),
  border_color_left = attr(tbl, "border_color_left"),
  border_color_right = attr(tbl, "border_color_right"),
  border_color_top = attr(tbl, "border_color_top"),
  border_color_bottom = attr(tbl, "border_color_bottom"),
  border_width = attr(tbl, "border_width"),
  col_rel_width = attr(tbl, "col_rel_width"),
  cell_height = attr(tbl, "cell_height"),
  cell_justification = attr(tbl, "cell_justification"),
  text_font = attr(tbl, "text_font"),
  text_format = attr(tbl, "text_format"),
  text_color = attr(tbl, "text_color"),
  text_background_color = attr(tbl, "text_background_color"),
  text_justification = attr(tbl, "text_justification"),
  text_font_size = attr(tbl, "text_font_size"),
  text_space_before = attr(tbl, "text_space_before"),
  text_space_after = attr(tbl, "text_space_after"),
  text_convert = attr(tbl, "text_convert")
)
}
\arguments{
\item{tbl}{A data frame.}

\item{col_total_width}{Column total width for the table. Default is the corresponding attribute from \code{tbl}.}

\item{use_border_bottom}{A logical value of using the bottom border. Default is the corresponding attribute from \code{tbl}.}

\item{border_left}{Left border type. Default is the corresponding attribute from \code{tbl}.}

\item{border_right}{Right border type. Default is the corresponding attribute from \code{tbl}.}

\item{border_top}{Top border type. Default is the corresponding attribute from \code{tbl}.}

\item{border_bottom}{Bottom border type. Default is the corresponding attribute from \code{tbl}.}

\item{border_color_left}{Left border color. Default is the corresponding attribute from \code{tbl}.}

\item{border_color_right}{Right border color. Default is the corresponding attribute from \code{tbl}.}

\item{border_color_top}{Top border color. Default is the corresponding attribute from \code{tbl}.}

\item{border_color_bottom}{Bottom border color. Default is the corresponding attribute from \code{tbl}.}

\item{border_width}{Border width in twips. Default is the corresponding attribute from \code{tbl}.}

\item{col_rel_width}{Column relative width in a vector eg. c(2,1,1) refers to 2:1:1}

\item{cell_height}{Height for cell in twips. Default is the corresponding attribute from \code{tbl}.}

\item{cell_justification}{Justification for cell. Default is the corresponding attribute from \code{tbl}.}

\item{text_font}{Text font type. Default is the corresponding attribute from \code{tbl}.}

\item{text_format}{Text format. Default is the corresponding attribute from \code{tbl}.}

\item{text_color}{Text color. Default is the corresponding attribute from \code{tbl}.}

\item{text_background_color}{Text background color. Default is the corresponding attribute from \code{tbl}.}

\item{text_justification}{Justification for text. Default is the corresponding attribute from \code{tbl}.}

\item{text_font_size}{Text font size. Default is the corresponding attribute from \code{tbl}.}

\item{text_space_before}{Line space before text. Default is the corresponding attribute from \code{tbl}.}

\item{text_space_after}{Line space after text. Default is the corresponding attribute from \code{tbl}.}

\item{text_convert}{A logical value to convert special characters. Default is the corresponding attribute from \code{tbl}.}
}
\description{
Create RTF Table Body Encode
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Define table begin and end in RTF syntax.
   \item Define cell justification using `justification()`, then covert the cell from inch to twip using `inch_to_twip()` in RTF syntax.
   \item Define cell border type using `border_type()` and cell border width in RTF syntax.
   \item Define cell border color using `color_table()` in RTF syntax.
   \item Define cell background color using input variable text_background_color in RTF syntax.
   \item Define cell size using `cell_size()` in RTF syntax.
   \item Combine cell component attributes into a single code string.
   \item Define cell content in encoded RTF syntax.
   \item Check if cell content format is a valid value.
   \item Combine cell content and content component attributes into a single code string.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

