% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_plots.R
\name{show_error_link_plots}
\alias{show_error_link_plots}
\title{Visualise the model overlaid on high-dimensional data along with 2-D wireframe model and error.}
\usage{
show_error_link_plots(
  point_data,
  edge_data,
  point_colours = c("#66B2CC", "#FF7755"),
  point_sizes = c(0, 1)
)
}
\arguments{
\item{point_data}{A tibble that contains the high-dimensional data, no-linear dimension reductions
and model in high-dimensions.}

\item{edge_data}{A tibble that contains the wireframe data (from and to).}

\item{point_colours}{A character vector that contains the colours of points in
the high-dimensional data and model.}

\item{point_sizes}{A numeric vector that contains the sizes of points in
the high-dimensional data and model.}
}
\value{
A browsable HTML element.
}
\description{
This function generates a LangeviTour visualisation based on different
conditions and input parameters with 2-D wireframe.
}
\examples{
model_error <- augment(highd_data = scurve, model_highd = scurve_model_obj$model_highd,
model_2d = scurve_model_obj$model_2d)
df_exe <- comb_all_data_model_error(highd_data = scurve, nldr_data = scurve_umap,
model_highd = scurve_model_obj$model_highd, model_2d = scurve_model_obj$model_2d,
error_data = model_error)
edge_data <- scurve_model_obj$trimesh_data
if (interactive()) {
  show_error_link_plots(point_data = df_exe, edge_data = edge_data)
}

}
