% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2d.R
\name{extract_hexbin_centroids}
\alias{extract_hexbin_centroids}
\title{Extract hexagonal bin centroids coordinates and the corresponding standardise counts.}
\usage{
extract_hexbin_centroids(centroids_data, counts_data)
}
\arguments{
\item{centroids_data}{A tibble that contains all hexagonal bin centroid
coordinates with hexagon IDs.}

\item{counts_data}{A tibble that contains hexagon IDs with the standardise
number of points within each hexagon.}
}
\value{
A tibble contains hexagon ID (\code{h}), centroid coordinates (\code{c_x}, \code{c_y}),
bin counts (\code{n_h}), and standardise counts (\code{w_h}).
}
\description{
Extract hexagonal bin centroids coordinates and the corresponding standardise counts.
}
\examples{
all_centroids_df <- scurve_model_obj$hb_obj$centroids
counts_data <- scurve_model_obj$hb_obj$std_cts
extract_hexbin_centroids(centroids_data = all_centroids_df,
counts_data = counts_data)

}
