% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{compute_aic}
\alias{compute_aic}
\title{Compute the Akaike Information Criterion (AIC) for a given model.}
\usage{
compute_aic(p, mse, num_bins, num_obs)
}
\arguments{
\item{p}{Number of dimensions of the data set.}

\item{mse}{Mean squared error (MSE) of the model.}

\item{num_bins}{Total number of bins without empty bins used in the model.}

\item{num_obs}{Total number of observations in the training or test set.}
}
\value{
The AIC value for the specified model.
}
\description{
Compute the Akaike Information Criterion (AIC) for a given model.
}
\examples{
# Example usage of compute_aic function
p <- 5
mse <- 1500
num_bins <- 10
num_obs <- 100
aic_value <- compute_aic(p, mse, num_bins, num_obs)
cat("AIC Value:", aic_value, "\n")

}
