% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_rep.R
\name{data_rep}
\alias{data_rep}
\title{Duplicate a data rows or columns X times}
\usage{
data_rep(., n, which = c("rows", "cols"))
}
\arguments{
\item{.}{data frame variable}

\item{n}{multiples of duplicate}

\item{which}{where to append the duplicated data e.g. rows or cols}
}
\value{
the duplicated dataset store to a variable with the name of the first
}
\description{
Add a data to itself X times by rows or columns
}
\examples{
# initialize p1 and p2
init(p1,p2)
p1
p2

# declare p1 and p2 as data frame
p1 <- data.frame(PK=1:10,ID2=1:10)
p2 <- data.frame(PK=11:20,ID2=21:30)

p1
p2

#add p1  twice by row, and resave as p1
data_rep(p1,n=2,"rows")
p1 #p1 has been updated


#add p2  3 times by col, and resave as p2
data_rep(p2,n=3,"cols")
p2 #p2 has been updated
}
