% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove.R
\name{quarto_remove_extension}
\alias{quarto_remove_extension}
\title{Remove a Quarto extensions}
\usage{
quarto_remove_extension(
  extension = NULL,
  no_prompt = FALSE,
  quiet = FALSE,
  quarto_args = NULL
)
}
\arguments{
\item{extension}{The extension name to remove, as in \verb{quarto remove <extension-name>}.}

\item{no_prompt}{Do not prompt to confirm approval to download external extension.}

\item{quiet}{Suppress warning and other messages, from R and also Quarto CLI
(i.e \code{--quiet} is passed as command line).

\code{quarto.quiet} \R option or \code{R_QUARTO_QUIET} environment variable can be used to globally override a function call
(This can be useful to debug tool that calls \verb{quarto_*} functions directly).

On Github Actions, it will always be \code{quiet = FALSE}.}

\item{quarto_args}{Character vector of other \code{quarto} CLI arguments to append
to the Quarto command executed by this function. This is mainly intended for
advanced usage and useful for CLI arguments which are not yet mirrored in a
dedicated parameter of this \R function. See \verb{quarto render --help} for options.}
}
\value{
Returns invisibly \code{TRUE} if the extension was removed, \code{FALSE} otherwise.
}
\description{
Remove an extension in this folder or project by running \verb{quarto remove}
}
\examples{
\dontrun{
# Remove an already installed extension
quarto_remove_extension("quarto-ext/fontawesome")
}
}
\seealso{
\code{quarto_add_extension()} and \href{https://quarto.org/docs/extensions/managing.html}{Quarto Website}.
}
