% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index.R
\name{index}
\alias{index}
\alias{is.index}
\title{Locate a pattern in a tokens object}
\usage{
index(
  x,
  pattern,
  valuetype = c("glob", "regex", "fixed"),
  case_insensitive = TRUE
)

is.index(x)
}
\arguments{
\item{x}{an input \link{tokens} object}

\item{pattern}{a character vector, list of character vectors, \link{dictionary},
or collocations object.  See \link{pattern} for details.}

\item{valuetype}{the type of pattern matching: \code{"glob"} for "glob"-style
wildcard expressions; \code{"regex"} for regular expressions; or \code{"fixed"} for
exact matching. See \link{valuetype} for details.}

\item{case_insensitive}{logical; if \code{TRUE}, ignore case when matching a
\code{pattern} or \link{dictionary} values}
}
\value{
a data.frame consisting of one row per pattern match, with columns
for the document name, index positions \code{from} and \code{to}, and the pattern
matched.

\code{is.index} returns \code{TRUE} if the object was created by
\code{\link[=index]{index()}}; \code{FALSE} otherwise.
}
\description{
Locates a \link{pattern} within a tokens object, returning the index positions of
the beginning and ending tokens in the pattern.
}
\examples{
toks <- tokens(data_corpus_inaugural[1:8])
index(toks, pattern = "secure*")
index(toks, pattern = c("secure*", phrase("united states"))) |> head()
}
