% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pxg.R
\name{plot_pxg}
\alias{plot_pxg}
\title{Plot phenotype vs genotype}
\usage{
plot_pxg(
  geno,
  pheno,
  sort = TRUE,
  SEmult = NULL,
  pooledSD = TRUE,
  swap_axes = FALSE,
  jitter = 0.2,
  force_labels = TRUE,
  alternate_labels = FALSE,
  omit_points = FALSE,
  ...
)
}
\arguments{
\item{geno}{Vector of genotypes, for example as produced by
\code{\link[=maxmarg]{maxmarg()}} with specific \code{chr} and \code{pos}.}

\item{pheno}{Vector of phenotypes.}

\item{sort}{If TRUE, sort genotypes from largest to smallest.}

\item{SEmult}{If specified, interval estimates of the within-group
averages will be displayed, as \verb{mean +/- SE * SEmult}.}

\item{pooledSD}{If TRUE and \code{SEmult} is specified, calculated
a pooled within-group SD. Otherwise, get separate estimates of
the within-group SD for each group.}

\item{swap_axes}{If TRUE, swap the axes, so that the genotypes are
on the y-axis and the phenotype is on the x-axis.}

\item{jitter}{Amount to jitter the points horizontally, if a vector
of length > 0, it is taken to be the actual jitter amounts
(with values between -0.5 and 0.5).}

\item{force_labels}{If TRUE, force all genotype labels to be shown.}

\item{alternate_labels}{If TRUE, place genotype labels in two rows}

\item{omit_points}{If TRUE, omit the points, just plotting the averages (and, potentially, the +/- SE intervals).}

\item{...}{Additional graphics parameters, passed to \code{plot()}.}
}
\value{
(Invisibly) A matrix with rows being the genotype groups
and columns for the means and (if \code{SEmult} is specified) the SEs.
}
\description{
Plot phenotype vs genotype for a single putative QTL and a single phenotype.
}
\section{Hidden graphics parameters}{

A number of graphics parameters can be passed via \code{...}. For
example, \code{bgcolor} to control the background color, and
\code{seg_width}, \code{seg_lwd}, and \code{seg_col} to control the lines at the
confidence intervals. Further, \code{hlines}, \code{hlines_col},
\code{hlines_lwd}, and \code{hlines_lty} to control the horizontal grid
lines. (Use \code{hlines=NA} to avoid plotting horizontal grid lines.)
Similarly \code{vlines}, \code{vlines_col}, \code{vlines_lwd}, and \code{vlines_lty}
for vertical grid lines. These are not included as formal
parameters in order to avoid cluttering the function definition.
}

\examples{
# read data
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
\dontshow{iron <- iron[,"16"]}

# insert pseudomarkers into map
map <- insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- calc_genoprob(iron, map, error_prob=0.002)

# inferred genotype at a 28.6 cM on chr 16
geno <- maxmarg(probs, map, chr=16, pos=28.6, return_char=TRUE)

# plot phenotype vs genotype
plot_pxg(geno, log10(iron$pheno[,1]), ylab=expression(log[10](Liver)))

# include +/- 2 SE intervals
plot_pxg(geno, log10(iron$pheno[,1]), ylab=expression(log[10](Liver)),
         SEmult=2)

# plot just the means
plot_pxg(geno, log10(iron$pheno[,1]), ylab=expression(log[10](Liver)),
         omit_points=TRUE)

# plot just the means +/- 2 SEs
plot_pxg(geno, log10(iron$pheno[,1]), ylab=expression(log[10](Liver)),
         omit_points=TRUE, SEmult=2)
}
\seealso{
\code{\link[=plot_coef]{plot_coef()}}
}
