% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_genoprobcomp.R
\name{plot_genoprobcomp}
\alias{plot_genoprobcomp}
\title{Plot comparison of two sets of genotype probabilities}
\usage{
plot_genoprobcomp(
  probs1,
  probs2,
  map,
  ind = 1,
  chr = NULL,
  geno = NULL,
  threshold = 0,
  n_colors = 256,
  swap_axes = FALSE,
  ...
)
}
\arguments{
\item{probs1}{Genotype probabilities (as produced by \code{\link[=calc_genoprob]{calc_genoprob()}})
or allele dosages (as produced by \code{\link[=genoprob_to_alleleprob]{genoprob_to_alleleprob()}}).}

\item{probs2}{A second set of genotype probabilities, just like \code{probs1}.}

\item{map}{Marker map (a list of vectors of marker positions).}

\item{ind}{Individual to plot, either a numeric index or an ID.}

\item{chr}{Selected chromosome to plot; a single character string.}

\item{geno}{Optional vector of genotypes or alleles to be shown
(vector of integers or character strings)}

\item{threshold}{Threshold for genotype probabilities; only genotypes that achieve
this value somewhere on the chromosome (in one or the other set of probabilities) will be shown.}

\item{n_colors}{Number of colors in each color scale.}

\item{swap_axes}{If TRUE, swap the axes, so that the genotypes are
on the x-axis and the chromosome position is on the y-axis.}

\item{...}{Additional graphics parameters passed to \code{\link[graphics:image]{graphics::image()}}.}
}
\value{
None.
}
\description{
Plot a comparison of two sets of genotype probabilities for one individual on one chromosome, as a heat map.
}
\details{
We plot the first set of probabilities in the range white to blue
and the second set in the range white to red and attempt to combine
them, for colors that are white, some amount of blue or red, or
where both are large something like blackish purple.
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
iron <- iron[228,"1"]   # subset to one individual on chr 1
map <- insert_pseudomarkers(iron$gmap, step=5)

# introduce genotype error and look at difference in genotype probabilities
pr_ne <- calc_genoprob(iron, map, error_prob=0.002)
iron$geno[[1]][1,2] <- 3
pr_e <- calc_genoprob(iron, map, error_prob=0.002)

# image of probabilities + comparison
\dontshow{old_mfrow <- par("mfrow")}
par(mfrow=c(3,1))
plot_genoprob(pr_ne, map, main="No error")
plot_genoprob(pr_e, map, main="With an error")
plot_genoprobcomp(pr_ne, pr_e, map, main="Comparison")
\dontshow{par(mfrow=old_mfrow)}

}
\seealso{
\code{\link[=plot_genoprob]{plot_genoprob()}}
}
