% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_sdp.R
\name{calc_sdp}
\alias{calc_sdp}
\title{Calculate strain distribution pattern from SNP genotypes}
\usage{
calc_sdp(geno)
}
\arguments{
\item{geno}{Matrix of SNP genotypes, markers x strains, coded as 1
(AA) and 3 (BB). Markers with values other than 1 or 3 are omitted,
and monomorphic markers, are omitted.}
}
\value{
A vector of strain distribution patterns: integers between
1 and \eqn{2^n - 2} where \eqn{n} is the number of strains, whose
binary representation indicates the strain genotypes.
}
\description{
Calculate the strain distribution patterns (SDPs) from the strain
genotypes at a set of SNPs.
}
\examples{
x <- rbind(m1=c(3, 1, 1, 1, 1, 1, 1, 1),
           m2=c(1, 3, 3, 1, 1, 1, 1, 1),
           m3=c(1, 1, 1, 1, 3, 3, 3, 3))
calc_sdp(x)
}
\seealso{
\code{\link[=invert_sdp]{invert_sdp()}}, \code{\link[=sdp2char]{sdp2char()}}
}
