% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_functions.R
\name{EM_calibration_gaussian_memory}
\alias{EM_calibration_gaussian_memory}
\title{EM calibration in the case of the gaussian copula (unsigned) with memory management}
\usage{
EM_calibration_gaussian_memory(
  Logf0Mat,
  Logf1Mat,
  F0Mat,
  F1Mat,
  Prior.init,
  R.init,
  Hconfig,
  Precision = 1e-06,
  threads_nb
)
}
\arguments{
\item{Logf0Mat}{a matrix containing the log(f0(xi_q))}

\item{Logf1Mat}{a matrix containing the log(f1(xi_q))}

\item{F0Mat}{a matrix containing the evaluation of the marginal cdf under H0 at each items, each column corresponding to a p-value serie.}

\item{F1Mat}{a matrix containing the evaluation of the marginal cdf under H1 at each items, each column corresponding to a p-value serie.}

\item{Prior.init}{the initialization of prior probabilities for each of the H-configurations.}

\item{R.init}{the initialization of the correlation matrix of the gaussian copula parameter.}

\item{Hconfig}{A list of all possible combination of H0 and H1 hypotheses generated by the \code{\link[=GetHconfig]{GetHconfig()}} function.}

\item{Precision}{Precision for the stop criterion. (Default is 1e-6)}

\item{threads_nb}{The number of threads to use.}
}
\value{
A list of 2 objects 'priorHconfig' and 'Rcopula'.
Object 'priorHconfig' is a vector of estimated prior probabilities for each of the H-configurations.
Object 'Rcopula' is the estimated correlation matrix of the gaussian copula.
}
\description{
EM calibration in the case of the gaussian copula (unsigned) with memory management
}
