/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.PreferenceManager;
import com.qarks.util.http.ProxySettings;
import com.qarks.util.stream.Base64Helper;
import com.qarks.util.ui.DialogUtilities;
import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import com.qarks.util.ui.swing.NumericDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class ProxyConfigurationPanel
extends JPanel
implements ActionListener {
    private JButton apply;
    private JCheckBox usesProxy;
    private JTextField proxyHost;
    private JTextField proxyPort;
    private JTextField proxyLogin;
    private JTextField proxyExclude;
    private JPasswordField proxyPassword;
    private PreferenceManager preferenceManager;
    private ProxySettingsListener listener;
    private boolean showConfiguration;

    public ProxyConfigurationPanel(PreferenceManager preferenceManager, boolean bl, ProxySettingsListener proxySettingsListener) {
        this(preferenceManager, bl, true, proxySettingsListener);
    }

    public ProxyConfigurationPanel(PreferenceManager preferenceManager, boolean bl, boolean bl2, ProxySettingsListener proxySettingsListener) {
        this.preferenceManager = preferenceManager;
        this.showConfiguration = bl;
        this.listener = proxySettingsListener;
        this.usesProxy = new JCheckBox(ResourceManager.getString((Object)ResourceKey.USES_PROXY));
        this.proxyHost = new JTextField(20);
        this.proxyPort = new JTextField(20);
        this.proxyLogin = new JTextField(20);
        this.proxyPassword = new JPasswordField(20);
        this.proxyExclude = new JTextField(20);
        this.proxyPort.setDocument(new NumericDocument());
        this.apply = new JButton(ResourceManager.getString((Object)ResourceKey.APPLY));
        this.apply.setEnabled(false);
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(5, 1, 5, 5));
        JPanel jPanel3 = new JPanel(new GridLayout(5, 1, 5, 5));
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        jPanel2.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKey.HOST)), 0);
        jPanel2.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKey.PORT)), 1);
        jPanel2.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKey.LOGIN)), 2);
        jPanel2.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKey.PASSWORD)), 3);
        jPanel2.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKey.PROXY_EXCLUDE)), 4);
        jPanel3.add((Component)this.proxyHost, 0);
        jPanel3.add((Component)this.proxyPort, 1);
        jPanel3.add((Component)this.proxyLogin, 2);
        jPanel3.add((Component)this.proxyPassword, 3);
        jPanel3.add((Component)this.proxyExclude, 4);
        JPanel jPanel4 = new JPanel(new BorderLayout(5, 5));
        jPanel4.add((Component)this.usesProxy, "North");
        jPanel4.add((Component)jPanel, "Center");
        jPanel4.setBorder(new CompoundBorder(new TitledBorder(ResourceManager.getString((Object)ResourceKey.SETTINGS)), new EmptyBorder(10, 10, 10, 10)));
        JPanel jPanel5 = new JPanel(new FlowLayout(2, 5, 5));
        jPanel5.add(this.apply);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel6.add((Component)jPanel4, gridBagConstraints);
        this.add((Component)jPanel6, "Center");
        if (bl2) {
            this.add((Component)jPanel5, "South");
        }
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ProxyConfigurationPanel.this.apply.setEnabled(true);
            }
        };
        this.usesProxy.addActionListener(this);
        this.proxyHost.addKeyListener(keyAdapter);
        this.proxyPort.addKeyListener(keyAdapter);
        this.proxyLogin.addKeyListener(keyAdapter);
        this.proxyPassword.addKeyListener(keyAdapter);
        this.proxyExclude.addKeyListener(keyAdapter);
        this.apply.addActionListener(this);
        try {
            String string = preferenceManager.getProperty("com.qarks.websearch.proxy.set", "false");
            this.usesProxy.setSelected("true".equals(string));
            string = preferenceManager.getProperty("com.qarks.websearch.proxy.host", "");
            this.proxyHost.setText(string);
            string = preferenceManager.getProperty("com.qarks.websearch.proxy.port", "");
            this.proxyPort.setText(string);
            string = preferenceManager.getProperty("com.qarks.websearch.proxy.login", "");
            this.proxyLogin.setText(string);
            string = preferenceManager.getProperty("com.qarks.websearch.proxy.password", "");
            this.proxyPassword.setText(Base64Helper.convertBase64StringToString(string));
            string = preferenceManager.getProperty("com.qarks.websearch.proxy.exclude", "");
            this.proxyExclude.setText(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void showDialog(Window window, PreferenceManager preferenceManager) {
        JDialog jDialog = new JDialog(window, ResourceManager.getString((Object)ResourceKey.PROXY_SETTINGS), Dialog.ModalityType.APPLICATION_MODAL);
        Container container = jDialog.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        ProxyConfigurationPanel proxyConfigurationPanel = new ProxyConfigurationPanel(preferenceManager, false, null);
        proxyConfigurationPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        container.add(proxyConfigurationPanel);
        jDialog.pack();
        if (window != null) {
            DialogUtilities.centerWindow(jDialog, window);
        } else {
            DialogUtilities.centerOnScreen(jDialog);
        }
    }

    public void apply() {
        this.actionPerformed(new ActionEvent(this.apply, 0, "Apply"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.apply) {
            try {
                this.preferenceManager.setProperty("com.qarks.websearch.proxy.set", this.usesProxy.isSelected() ? "true" : "false");
                this.preferenceManager.setProperty("com.qarks.websearch.proxy.host", this.proxyHost.getText());
                this.preferenceManager.setProperty("com.qarks.websearch.proxy.port", this.proxyPort.getText());
                this.preferenceManager.setProperty("com.qarks.websearch.proxy.login", this.proxyLogin.getText());
                this.preferenceManager.setProperty("com.qarks.websearch.proxy.password", Base64Helper.convertStringToBase64String(new String(this.proxyPassword.getPassword())));
                this.preferenceManager.setProperty("com.qarks.websearch.proxy.exclude", new String(this.proxyExclude.getText()));
                this.preferenceManager.flush();
                ProxySettings.getAndApplyProxySettings(this.preferenceManager);
                if (this.showConfiguration) {
                    JOptionPane.showMessageDialog(this, ResourceManager.getString((Object)ResourceKey.SETTINGS_CHANGED), ResourceManager.getString((Object)ResourceKey.SAVE), 1);
                }
                if (this.listener != null) {
                    this.listener.onProxySettingsApplied();
                }
                this.apply.setEnabled(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, exception.getMessage(), ResourceManager.getString((Object)ResourceKey.SAVE), 0);
            }
        } else if (object == this.usesProxy) {
            this.apply.setEnabled(true);
        }
    }

    public static interface ProxySettingsListener {
        public void onProxySettingsApplied();
    }
}

