% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{varsel-statistics}
\alias{varsel-statistics}
\alias{varsel_plot}
\alias{varsel_stats}
\title{Plotting or printing summary statistics related to variable selection}
\usage{
varsel_plot(object, ..., nv_max = NULL, stats = NULL, deltas = F,
  alpha = 0.1)

varsel_stats(object, ..., nv_max = NULL, type = "mean", deltas = F,
  alpha = 0.1)
}
\arguments{
\item{object}{The object returned by \link[=varsel]{varsel} or
\link[=cv_varsel]{cv_varsel}.}

\item{...}{Currently ignored.}

\item{nv_max}{Maximum submodel size for which the statistics are calculated.}

\item{stats}{A list of strings of statistics to calculate. Available
options are: mlpd, kl, mse (gaussian only), pctcorr (binomial only).
If \code{NULL}, set to varsel_plot plots only mlpd, but varsel_stats
return all the statistics.}

\item{deltas}{If \code{TRUE}, the difference between the full model and the
submodel is returned instead of the actual value of the statistic.
Defaults to \code{FALSE}.}

\item{alpha}{A number indicating the desired coverage of the credible
intervals. Eg. \code{alpha=0.1} corresponds to 90\% probability mass
within the intervals. Defaults to \code{0.1}.}

\item{type}{One of 'mean', 'lower', 'upper' indicating whether to compute mean,
or either the lower or upper credible bound. Upper and lower bounds are determined so
that \code{1-alpha} percent of the mass falls between them.}
}
\description{
\code{varsel_stats} can be used to obtain summary statistics related to
variable selection. The same statistics can be plotted with
\code{varsel_plot}.
}
