% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conformal_infer.R
\name{control_conformal_full}
\alias{control_conformal_full}
\title{Controlling the numeric details for conformal inference}
\usage{
control_conformal_full(
  method = "iterative",
  trial_points = 100,
  var_multiplier = 10,
  max_iter = 100,
  tolerance = .Machine$double.eps^0.25,
  progress = FALSE,
  required_pkgs = character(0),
  seed = sample.int(10^5, 1)
)
}
\arguments{
\item{method}{The method for computing the intervals. The options are
\code{'search'} (using) \code{\link[stats:uniroot]{stats::uniroot()}}, and \code{'grid'}.}

\item{trial_points}{When \code{method = "grid"}, how many points should be
evaluated?}

\item{var_multiplier}{A multiplier for the variance model that determines the
possible range of the bounds.}

\item{max_iter}{When \code{method = "iterative"}, the maximum number of iterations.}

\item{tolerance}{Tolerance value passed to \code{\link[=all.equal]{all.equal()}} to determine
convergence during the search computations.}

\item{progress}{Should a progress bar be used to track execution?}

\item{required_pkgs}{An optional character string for which packages are
required.}

\item{seed}{A single integer used to control randomness when models are
(re)fit.}
}
\value{
A list object with the options given by the user.
}
\description{
Controlling the numeric details for conformal inference
}
