% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dprimarycensored.R
\name{dprimarycensored}
\alias{dprimarycensored}
\alias{dpcens}
\title{Compute the primary event censored PMF for delays}
\usage{
dprimarycensored(
  x,
  pdist,
  pwindow = 1,
  swindow = 1,
  D = Inf,
  dprimary = stats::dunif,
  dprimary_args = list(),
  log = FALSE,
  pdist_name = lifecycle::deprecated(),
  dprimary_name = lifecycle::deprecated(),
  ...
)

dpcens(
  x,
  pdist,
  pwindow = 1,
  swindow = 1,
  D = Inf,
  dprimary = stats::dunif,
  dprimary_args = list(),
  log = FALSE,
  pdist_name = lifecycle::deprecated(),
  dprimary_name = lifecycle::deprecated(),
  ...
)
}
\arguments{
\item{x}{Vector of quantiles}

\item{pdist}{Distribution function (CDF). The package can identify base R
distributions for potential analytical solutions. For non-base R functions,
users can apply \code{\link[=add_name_attribute]{add_name_attribute()}} to yield properly tagged
functions if they wish to leverage the analytical solutions.}

\item{pwindow}{Primary event window}

\item{swindow}{Secondary event window (default: 1)}

\item{D}{Maximum delay (truncation point). If finite, the distribution is
truncated at D. If set to Inf, no truncation is applied. Defaults to Inf.}

\item{dprimary}{Function to generate the probability density function
(PDF) of primary event times. This function should take a value \code{x} and a
\code{pwindow} parameter, and return a probability density. It should be
normalized to integrate to 1 over [0, pwindow]. Defaults to a uniform
distribution over [0, pwindow]. Users can provide custom functions or use
helper functions like \code{dexpgrowth} for an exponential growth distribution.
See \code{primary_dists.R} for examples. The package can identify base R
distributions for potential analytical solutions. For non-base R functions,
users can apply \code{\link[=add_name_attribute]{add_name_attribute()}} to yield properly tagged
functions if they wish to leverage analytical solutions.}

\item{dprimary_args}{List of additional arguments to be passed to
dprimary. For example, when using \code{dexpgrowth}, you would
pass \code{list(min = 0, max = pwindow, r = 0.2)} to set the minimum, maximum,
and rate parameters}

\item{log}{Logical; if TRUE, probabilities p are given as log(p)}

\item{pdist_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} this argument will be
ignored in future versions; use \code{\link[=add_name_attribute]{add_name_attribute()}} on \code{pdist}
instead}

\item{dprimary_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} this argument will be
ignored in future versions; use \code{\link[=add_name_attribute]{add_name_attribute()}} on \code{dprimary}
instead}

\item{...}{Additional arguments to be passed to the distribution function}
}
\value{
Vector of primary event censored PMFs, normalized by D if finite
(truncation adjustment)
}
\description{
This function computes the primary event censored probability mass function
(PMF) for a given set of quantiles. It adjusts the PMF of the primary event
distribution by accounting for the delay distribution and potential
truncation at a maximum delay (D). The function allows for custom primary
event distributions and delay distributions.
}
\details{
The primary event censored PMF is computed by taking the difference of the
primary event censored cumulative distribution function (CDF) at two points,
\eqn{d + \text{swindow}} and \eqn{d}. The primary event censored PMF,
\eqn{f_{\text{cens}}(d)}, is given by:
\deqn{
f_{\text{cens}}(d) = F_{\text{cens}}(d + \text{swindow}) - F_{\text{cens}}(d)
}
where \eqn{F_{\text{cens}}} is the primary event censored CDF.

The function first computes the CDFs for all unique points (including both
\eqn{d} and \eqn{d + \text{swindow}}) using \code{\link[=pprimarycensored]{pprimarycensored()}}. It then
creates a lookup table for these CDFs to efficiently calculate the PMF for
each input value. For non-positive delays, the function returns 0.

If a finite maximum delay \eqn{D} is specified, the PMF is normalized to
ensure it sums to 1 over the range [0, D]. This normalization can be
expressed as:
\deqn{
f_{\text{cens,norm}}(d) = \frac{f_{\text{cens}}(d)}{\sum_{i=0}^{D-1}
 f_{\text{cens}}(i)}
}
where \eqn{f_{\text{cens,norm}}(d)} is the normalized PMF and
\eqn{f_{\text{cens}}(d)} is the unnormalized PMF. For the explanation and
mathematical details of the CDF, refer to the documentation of
\code{\link[=pprimarycensored]{pprimarycensored()}}.
}
\examples{
# Example: Weibull distribution with uniform primary events
dprimarycensored(c(0.1, 0.5, 1), pweibull, shape = 1.5, scale = 2.0)

# Example: Weibull distribution with exponential growth primary events
dprimarycensored(
  c(0.1, 0.5, 1), pweibull,
  dprimary = dexpgrowth,
  dprimary_args = list(r = 0.2), shape = 1.5, scale = 2.0
)
}
\seealso{
Primary event censored distribution functions
\code{\link{pprimarycensored}()},
\code{\link{rprimarycensored}()}
}
\concept{primarycensored}
