% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prider.R
\name{prepare_primer_df}
\alias{prepare_primer_df}
\title{Prepare a primer table for downstream analyses}
\usage{
prepare_primer_df(
  input_fasta,
  primer_length = 20,
  GCcheck = FALSE,
  GCmin = 0.4,
  GCmax = 0.6,
  GChalves = FALSE,
  GCsimilarity = 0.1
)
}
\arguments{
\item{input_fasta}{A string. Name or filepath of the input FASTA file.}

\item{primer_length}{A number. Sets the primer length. For applications
involving two adjacent probes, the value should be set to two-fold
the length of a single probe.}

\item{GCcheck}{A logical. If TRUE, checks the GC contents of the primers and
filters based on GCmin and GCmax.}

\item{GCmin}{A decimal. If GCcheck is performed, this parameter determines
the minimum proportional GC content.}

\item{GCmax}{A decimal. If GCcheck is performed, this parameter determines
the maximum proportional GC content.}

\item{GChalves}{A logical. If TRUE, checks the GC contents separately for
both halves of the primers and filters based on GCsimilarity. For
example for applications involving two adjacent probes.}

\item{GCsimilarity}{A number. If GChalves is performed, this parameter
determines the maximum proportional GC content
difference between the primer halves.}
}
\value{
A list containing sequence id conversions, primer matrix
        and a list of primers with their target sequences.
}
\description{
Prepare a primer table for downstream analyses
}
