% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reeh_ptp.R
\name{calculate_reeh_2019_basic_ptp}
\alias{calculate_reeh_2019_basic_ptp}
\title{Calculate 2019 Reeh Basic PTP for obstructive CAD}
\usage{
calculate_reeh_2019_basic_ptp(age, sex, symptom_type)
}
\arguments{
\item{age}{Input integer value to indicate the age of the patient.}

\item{sex}{Input characters (female, male) to indicate the sex of the patient.
\itemize{
  \item female
  \item male
}}

\item{symptom_type}{Input characters (typical, atypical, nonanginal, dyspnoea)
to indicate the symptom characteristics of the patient.
\itemize{
  \item typical stands for the patient having typical chest pain.
  \item atypical stands for the patient having atypical chest pain.
  \item nonanginal stands for the patient having nonanginal or non-specific chest pain.
  \item dyspnoea stands for the patient having dyspnoea.
}}
}
\value{
A numeric value representing the patient's PTP for obstructive CAD
based on the 2019 Reeh et. al. basic model.
}
\description{
This function returns a patient's
pre-test probability (PTP) of obstructive
coronary artery disease based on the
2019 Reeh et. al. basic model.
}
\details{
The predictive model is based on 3903
patients free of CAD and heart failure and suspected of angina, who were referred
to a single, large, urban university hospital for assessment in 2012–15.
}
\examples{
# 40 year old female with typical chest pain
calculate_reeh_2019_basic_ptp(
    age = 40,
    sex = "female",
    symptom_type = "typical"
)
}
