% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_measures.R
\name{prec_cor}
\alias{prec_cor}
\title{Sample size or precision for correlation coefficient}
\usage{
prec_cor(
  r,
  n = NULL,
  conf.width = NULL,
  conf.level = 0.95,
  method = c("pearson", "kendall", "spearman"),
  ...
)
}
\arguments{
\item{r}{desired correlation coefficient.}

\item{n}{sample size.}

\item{conf.width}{precision (the full width of the confidence interval).}

\item{conf.level}{confidence level.}

\item{method}{Exactly one of \code{pearson} (\emph{default}), \code{kendall},
or \code{spearman}. Methods can be abbreviated.}

\item{...}{other options to uniroot (e.g. \code{tol})}
}
\value{
Object of class "presize", a list of arguments (including the
  computed one) augmented with method and note elements.
}
\description{
\code{prec_cor} returns the sample size or the precision for the given
pearson, spearman, or kendall correlation coefficient.
}
\details{
Exactly one of the parameters \code{n} or \code{conf.width} must be passed as NULL,
and that parameter is determined from the other.

Sample size or precision is calculated according to formula 2 in Bonett and
Wright (2000). The use of pearson is only recommended, if \eqn{n \ge 25}. The
pearson correlation coefficient assumes bivariate normality. If the
assumption of bivariate normality cannot be met, spearman or kendall should
be considered.

n is rounded up to the next whole number using \code{ceiling}.

\code{\link[stats]{uniroot}} is used to solve n.
}
\references{
Bonett DG, and Wright TA (2000) \emph{Sample size requirements
  for estimating Pearson, Kendall and Spearman correlations} Psychometrika
  65:23-28. \href{https://doi.org/10.1007/BF02294183}{doi:10.1007/BF02294183}
}
