skip_on_cran()

library(testthat)

test_that("x_from_power: es", {

# Case 1

mod <-
"
m ~ x
y ~ m + x
"

mod_es <-
"
m ~ x: s
y ~ m: m
y ~ x: s
"

out <- power4test(nrep = 50,
                  model = mod,
                  pop_es = mod_es,
                  n = 50,
                  fit_model_args = list(fit_function = "lm"),
                  test_fun = test_parameters,
                  test_args = list(pars = "y~m"),
                  iseed = 1234,
                  parallel = FALSE,
                  progress = FALSE)
out_power <- rejection_rates(out)
out_power

expect_no_error(tmp <- x_from_power(out,
                    x = "es",
                    pop_es_name = "m ~ x",
                    target_power = .70,
                    final_nrep = 60,
                    max_trials = 2,
                    seed = 2345,
                    progress = TRUE,
                    simulation_progress = FALSE,
                    what = "ub"))
expect_no_error(print(summary(tmp)))
expect_true(abs(tmp$ci_final - tmp$target_power)[2] < formals(x_from_power)$tolerance)

tmp2 <- x_from_power(tmp,
                    x = "es",
                    pop_es_name = "m ~ x",
                    target_power = .70,
                    final_nrep = 60,
                    max_trials = 2,
                    seed = 2345,
                    progress = TRUE,
                    simulation_progress = FALSE,
                    what = "ub")
expect_identical(tmp2,
                 tmp)

tmp3 <- x_from_power(tmp$power4test_trials,
                    x = "es",
                    pop_es_name = "m ~ x",
                    target_power = .70,
                    final_nrep = 60,
                    max_trials = 2,
                    seed = 2345,
                    progress = TRUE,
                    simulation_progress = FALSE,
                    what = "ub")
expect_identical(tmp3$x_tried,
                 tmp$x_tried)
expect_identical(tmp3$x_final,
                 tmp$x_final)

expect_no_error(tmp <- x_from_power(out,
                    x = "es",
                    pop_es_name = "m ~ x",
                    target_power = .60,
                    final_nrep = 60,
                    max_trials = 2,
                    seed = 2345,
                    progress = TRUE,
                    simulation_progress = FALSE,
                    what = "lb"))
expect_no_error(print(summary(tmp)))
expect_true(abs(tmp$ci_final - tmp$args$target_power)[1] < formals(x_from_power)$tolerance)

})
