//
//  utilita.cpp
//  POSet
//
//  Created by Alessandro Avellone on 09/04/2019.
//  Copyright © 2019 Alessandro Avellone. All rights reserved.
//

#include <fstream>
#include <vector>
#include <string>
#include <list>
#include <memory>
#include <mutex>
#include <filesystem>

#include "utilita.h"

std::mutex semaphore_cout;

// ***********************************************
// ***********************************************
// ***********************************************

std::string& FindAndReplaceAll(std::string& data, std::string toSearch, std::string replaceStr)
{
    // Get the first occurrence
    size_t pos = data.find(toSearch);
    
    // Repeat till end is reached
    while( pos != std::string::npos)
    {
        // Replace this occurrence of Sub String
        data.replace(pos, toSearch.size(), replaceStr);
        // Get the next occurrence from the current position
        pos = data.find(toSearch, pos + replaceStr.size());
    }
    return data;
}

// ***********************************************
// ***********************************************
// ***********************************************

std::string to_string(std::vector<std::vector<double>>& v, char DELIMETER = ';')
{
    std::string r = "";
    for (size_t k = 0; k <  v.size(); ++k)
    {
        bool first = true;
        for (size_t h = 0; h < v.at(k).size(); ++h)
        {
            if (first)
            {
                r += std::to_string(v.at(k).at(h));
                first = false;
            }
            else
            {
                r += DELIMETER + std::to_string(v.at(k).at(h));
            }
        }
        r += "\n";
    }
    
    return r;
}

//************************************
//************************************
//************************************

std::vector<std::string>& split(const std::string &text, char sep) {
    static std::vector<std::string> tokens;
    
    tokens.clear();
    std::uint64_t start = 0, end = 0;
    while ((end = text.find(sep, start)) != std::string::npos) {
        tokens.push_back(text.substr(start, end - start));
        start = end + 1;
    }
    tokens.push_back(text.substr(start));
    return tokens;
}

//************************************
//************************************
//************************************

void LTrim(std::string &s) {
    s.erase(s.begin(), std::find_if(s.begin(), s.end(), [](int ch) {
        return !std::isspace(ch);
    }));
}

//************************************
//************************************
//************************************

void RTrim(std::string &s) {
    s.erase(std::find_if(s.rbegin(), s.rend(), [](int ch) {
        return !std::isspace(ch);
    }).base(), s.end());
}

//************************************
//************************************
//************************************

void Trim(std::string &s) {
    LTrim(s);
    RTrim(s);
}

//************************************
//************************************
//************************************

std::string to_bitstring (std::uint64_t n, std::uint64_t cardinality) {
    std::string ris = "";
    for (std::uint64_t i = 0; i < cardinality; ++i) {
        std::uint64_t v = n & 1;
        ris = std::to_string(v) + ris;
        n = n >> 1;
    }
    return ris;
}




//************************************
//************************************
//************************************
