% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff_sample_size.R
\name{eff_sample_size}
\alias{eff_sample_size}
\alias{eff_sample_size,missing-method}
\alias{eff_sample_size,ANY-method}
\alias{eff_sample_size,bsmcd_pomp-method}
\alias{eff_sample_size,pfilterd_pomp-method}
\alias{eff_sample_size,wpfilterd_pomp-method}
\alias{eff_sample_size,pfilterList-method}
\title{Effective sample size}
\usage{
\S4method{eff_sample_size}{bsmcd_pomp}(object, ..., format = c("numeric", "data.frame"))

\S4method{eff_sample_size}{pfilterd_pomp}(object, ..., format = c("numeric", "data.frame"))

\S4method{eff_sample_size}{wpfilterd_pomp}(object, ..., format = c("numeric", "data.frame"))

\S4method{eff_sample_size}{pfilterList}(object, ..., format = c("numeric", "data.frame"))
}
\arguments{
\item{object}{result of a filtering computation}

\item{...}{ignored}

\item{format}{format of the returned object}
}
\description{
Estimate the effective sample size of a Monte Carlo computation.
}
\details{
Effective sample size is computed as
\deqn{\left(\sum_i\!w_{it}^2\right)^{-1},}{1/(sum(w_it^2)),}
where \eqn{w_{it}}{w_it} is the normalized weight of particle \eqn{i} at time \eqn{t}.
}
\seealso{
More on sequential Monte Carlo methods: 
\code{\link{bsmc2}()},
\code{\link{cond_logLik}()},
\code{\link{filter_mean}()},
\code{\link{filter_traj}()},
\code{\link{kalman}},
\code{\link{mif2}()},
\code{\link{pfilter}()},
\code{\link{pmcmc}()},
\code{\link{pred_mean}()},
\code{\link{pred_var}()},
\code{\link{saved_states}()},
\code{\link{wpfilter}()}

Other extraction methods: 
\code{\link{coef}()},
\code{\link{cond_logLik}()},
\code{\link{covmat}()},
\code{\link{filter_mean}()},
\code{\link{filter_traj}()},
\code{\link{forecast}()},
\code{\link{logLik}},
\code{\link{obs}()},
\code{\link{pred_mean}()},
\code{\link{pred_var}()},
\code{\link{saved_states}()},
\code{\link{spy}()},
\code{\link{states}()},
\code{\link{summary}()},
\code{\link{time}()},
\code{\link{timezero}()},
\code{\link{traces}()}
}
\concept{extraction methods}
\concept{particle filter methods}
