% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proposals.R
\name{proposals}
\alias{proposals}
\alias{mvn_diag_rw}
\alias{mvn_rw}
\alias{mvn_rw_adaptive}
\title{MCMC proposal distributions}
\usage{
mvn_diag_rw(rw.sd)

mvn_rw(rw.var)

mvn_rw_adaptive(
  rw.sd,
  rw.var,
  scale.start = NA,
  scale.cooling = 0.999,
  shape.start = NA,
  target = 0.234,
  max.scaling = 50
)
}
\arguments{
\item{rw.sd}{named numeric vector; random-walk SDs for a multivariate
normal random-walk proposal with diagonal variance-covariance matrix.}

\item{rw.var}{square numeric matrix with row- and column-names.  Specifies
the variance-covariance matrix for a multivariate normal random-walk
proposal distribution.}

\item{scale.start, scale.cooling, shape.start, target, max.scaling}{parameters
to control the proposal adaptation algorithm.  Beginning with MCMC
iteration \code{scale.start}, the scale of the proposal covariance matrix
will be adjusted in an effort to match the \code{target} acceptance ratio.
This initial scale adjustment is \dQuote{cooled}, i.e., the adjustment
diminishes as the chain moves along.  The parameter \code{scale.cooling}
specifies the cooling schedule: at n iterations after \code{scale.start},
the current scaling factor is multiplied with \code{scale.cooling^n}.  The
maximum scaling factor allowed at any one iteration is \code{max.scaling}.
After \code{shape.start} accepted proposals have accumulated, a scaled
empirical covariance matrix will be used for the proposals, following
Roberts and Rosenthal (2009).}
}
\value{
Each of these calls constructs a function suitable for use as the
\code{proposal} argument of \code{pmcmc} or \code{abc}.  Given a parameter
vector, each such function returns a single draw from the corresponding
proposal distribution.
}
\description{
Functions to construct proposal distributions for use with MCMC methods.
}
\references{
\Roberts2009
}
\seealso{
More on Markov chain Monte Carlo methods:
\code{\link{approximate Bayesian computation}},
\code{\link{pmcmc}()}
}
\author{
Aaron A. King, Sebastian Funk
}
\concept{MCMC methods}
