% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R, R/objfun.R
\docType{methods}
\name{coef}
\alias{coef}
\alias{coef<-}
\alias{coef<-,missing-method}
\alias{coef,listie-method}
\alias{coef,pomp-method}
\alias{coef<-,pomp-method}
\alias{coef,objfun-method}
\alias{coef<-,objfun-method}
\title{Extract, set, or alter coefficients}
\usage{
\S4method{coef}{listie}(object, ...)

\S4method{coef}{pomp}(object, pars, transform = FALSE, ...)

\S4method{coef}{pomp}(object, pars, transform = FALSE, ...) <- value

\S4method{coef}{objfun}(object, ...)

\S4method{coef}{objfun}(object, pars, transform = FALSE, ...) <- value
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class extending \sQuote{pomp}}

\item{\dots}{ignored or passed to the more primitive function}

\item{pars}{optional character; names of parameters to be retrieved or set.}

\item{transform}{logical; perform parameter transformation?}

\item{value}{numeric vector or list; values to be assigned.
If \code{value = NULL}, the parameters are unset.}
}
\description{
Extract, set, or modify the estimated parameters from a fitted model.
}
\details{
\code{coef} allows one to extract the parameters from a fitted model.

\code{coef(object,transform=TRUE)} returns the parameters transformed onto
the estimation scale.

\code{coef(object) <- value} sets or alters the coefficients of a
\sQuote{pomp} object.

\code{coef(object,transform=TRUE) <- value} assumes that \code{value} is on
the estimation scale, and applies the \dQuote{from estimation scale}
parameter transformation from \code{object} before altering the
coefficients.
}
\seealso{
Other extraction methods: 
\code{\link{cond_logLik}()},
\code{\link{covmat}()},
\code{\link{eff_sample_size}()},
\code{\link{filter_mean}()},
\code{\link{filter_traj}()},
\code{\link{forecast}()},
\code{\link{logLik}},
\code{\link{obs}()},
\code{\link{pred_mean}()},
\code{\link{pred_var}()},
\code{\link{saved_states}()},
\code{\link{spy}()},
\code{\link{states}()},
\code{\link{summary}()},
\code{\link{timezero}()},
\code{\link{time}()},
\code{\link{traces}()}
}
\concept{extraction methods}
