% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saved_states.R
\name{saved.states}
\alias{saved.states}
\alias{saved.states,ANY-method}
\alias{saved.states,missing-method}
\alias{saved.states,pfilterd_pomp-method}
\alias{saved.states,pfilterList-method}
\title{Saved states}
\usage{
\S4method{saved.states}{pfilterd_pomp}(object, ..., format = c("list", "data.frame"))

\S4method{saved.states}{pfilterList}(object, ...)
}
\arguments{
\item{object}{result of a filtering computation}

\item{...}{ignored}

\item{format}{character;
format of the returned object (see below).}
}
\value{
According to the \code{format} argument, the saved states are returned either as a list or a data frame.

If \code{format="data.frame"}, then the returned data frame holds the state variables and (optionally) the unnormalized log weight of each particle at each observation time.
The \code{.id} variable distinguishes particles.

If \code{format="list"} and \code{\link{pfilter}} was called with \code{save.states="unweighted"} or \code{save.states="TRUE"}, the returned list contains one element per observation time.
Each element consists of a matrix, with one row for each state variable and one column for each particle.
If \code{\link{pfilter}} was called with \code{save.states="weighted"}, the list itself contains two lists:
the first holds the particles as above, the second holds the corresponding unnormalized log weights.
In particular, it has one element per observation time; each element is the vector of per-particle log weights.
}
\description{
Retrieve latent state trajectories from a particle filter calculation.
}
\details{
When one calls \code{\link{pfilter}} with \code{save.states=TRUE}, the latent state vector associated with each particle is saved.
This can be extracted by calling \code{saved.states} on the \sQuote{pfilterd.pomp} object.
These are the \emph{unweighted} particles, saved \emph{after} resampling.
}
\seealso{
More on sequential Monte Carlo methods: 
\code{\link{bsmc2}()},
\code{\link{cond.logLik}()},
\code{\link{eff.sample.size}()},
\code{\link{filter.mean}()},
\code{\link{filter.traj}()},
\code{\link{kalman}},
\code{\link{mif2}()},
\code{\link{pfilter}()},
\code{\link{pmcmc}()},
\code{\link{pred.mean}()},
\code{\link{pred.var}()},
\code{\link{wpfilter}()}

Other extraction methods: 
\code{\link{coef}()},
\code{\link{cond.logLik}()},
\code{\link{covmat}()},
\code{\link{eff.sample.size}()},
\code{\link{filter.mean}()},
\code{\link{filter.traj}()},
\code{\link{forecast}()},
\code{\link{logLik}},
\code{\link{obs}()},
\code{\link{pred.mean}()},
\code{\link{pred.var}()},
\code{\link{spy}()},
\code{\link{states}()},
\code{\link{summary}()},
\code{\link{timezero}()},
\code{\link{time}()},
\code{\link{traces}()}
}
\concept{extraction methods}
\concept{particle filter methods}
