% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wquant.R
\name{wquant}
\alias{wquant}
\title{Weighted quantile function}
\usage{
wquant(
  x,
  weights,
  probs = c(`0\%` = 0, `25\%` = 0.25, `50\%` = 0.5, `75\%` = 0.75, `100\%` = 1)
)
}
\arguments{
\item{x}{numeric; a vector of data.}

\item{weights}{numeric; vector of weights.}

\item{probs}{numeric; desired quantiles.}
}
\value{
\code{wquant} returns a vector containing the quantiles.
If \code{probs} has names, these are inherited.
}
\description{
Computes weighted quantiles.
}
\details{
\code{wquant} computes a quantile of type 7 according to the typology of \code{\link[stats]{quantile}}.
}
\examples{
x <- c(1,1,1,2,2,3,3,3,3,4,5,5,6,6,6)
quantile(x)
wquant(c(1,2,3,4,5,6),weights=c(3,2,4,1,2,3))

}
\author{
Aaron A. King
}
