% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R, R/profile_design.R, R/runif_design.R,
%   R/slice_design.R, R/sobol_design.R
\name{design}
\alias{design}
\alias{profile_design}
\alias{runif_design}
\alias{slice_design}
\alias{sobol_design}
\title{Design matrices for pomp calculations}
\usage{
profile_design(
  ...,
  lower,
  upper,
  nprof,
  type = c("runif", "sobol"),
  stringsAsFactors = getOption("stringsAsFactors", FALSE)
)

runif_design(lower = numeric(0), upper = numeric(0), nseq)

slice_design(center, ...)

sobol_design(lower = numeric(0), upper = numeric(0), nseq)
}
\arguments{
\item{...}{In \code{profile_design}, additional arguments specify the parameters over which to profile and the values of these parameters.
In \code{slice_design}, additional numeric vector arguments specify the locations of points along the slices.}

\item{lower, upper}{named numeric vectors giving the lower and upper bounds
of the ranges, respectively.}

\item{nprof}{The number of points per profile point.}

\item{type}{the type of design to use.
\code{type="runif"} uses \code{\link{runif_design}}.
\code{type="sobol"} uses \code{\link{sobol_design}};}

\item{stringsAsFactors}{should character vectors be converted to factors?}

\item{nseq}{Total number of points requested.}

\item{center}{\code{center} is a named numeric vector specifying the point
through which the slice(s) is (are) to be taken.}
}
\value{
\code{profile_design} returns a data frame with \code{nprof} points per profile point.

\code{runif_design} returns a data frame with \code{nseq} rows and one column for each variable named in \code{lower} and \code{upper}.

\code{slice_design} returns a data frame with one row per point.
The \sQuote{slice} variable indicates which slice the point belongs to.

\code{sobol_design} returns a data frame with \code{nseq} rows and one column for each variable named in \code{lower} and \code{upper}.
}
\description{
These functions are useful for generating designs for the exploration of parameter space.

\code{profile_design} generates a data-frame where each row can be used as the starting point for a profile likelihood calculation.

\code{runif_design} generates a design based on random samples from a multivariate uniform distribution.

\code{slice_design} generates points along slices through a specified point.

\code{sobol_design} generates a Latin hypercube design based on the Sobol' low-discrepancy sequence.
}
\details{
The Sobol' sequence generation is performed using codes from the \pkg{NLopt} library by S. Johnson.
}
\examples{
## Sobol' low-discrepancy design
plot(sobol_design(lower=c(a=0,b=100),upper=c(b=200,a=1),nseq=100))

## Uniform random design
plot(runif_design(lower=c(a=0,b=100),upper=c(b=200,a=1),100))

## A one-parameter profile design:
x <- profile_design(p=1:10,lower=c(a=0,b=0),upper=c(a=1,b=5),nprof=20)
dim(x)
plot(x)

## A two-parameter profile design:
x <- profile_design(p=1:10,q=3:5,lower=c(a=0,b=0),upper=c(b=5,a=1),nprof=200)
dim(x)
plot(x)

## A two-parameter profile design with random points:
x <- profile_design(p=1:10,q=3:5,lower=c(a=0,b=0),upper=c(b=5,a=1),nprof=200,type="runif")
dim(x)
plot(x)

## A single 11-point slice through the point c(A=3,B=8,C=0) along the B direction.
x <- slice_design(center=c(A=3,B=8,C=0),B=seq(0,10,by=1))
dim(x)
plot(x)

## Two slices through the same point along the A and C directions.
x <- slice_design(c(A=3,B=8,C=0),A=seq(0,5,by=1),C=seq(0,5,length=11))
dim(x)
plot(x)

}
\references{
\Kucherenko2005

\NLopt

\Bratley1988

\Joe2003
}
\author{
Aaron A. King
}
\keyword{design}
