% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_var.R
\name{pred.var}
\alias{pred.var}
\alias{pred.var,ANY-method}
\alias{pred.var,missing-method}
\alias{pred.var-pfilterd_pomp}
\alias{pred.var,pfilterd_pomp-method}
\title{Prediction variance}
\usage{
\S4method{pred.var}{pfilterd_pomp}(object, vars, ...)
}
\arguments{
\item{object}{result of a filtering computation}

\item{vars}{optional character; names of variables}

\item{...}{ignored}
}
\description{
The variance of the prediction distribution
}
\details{
The prediction distribution is that of
\deqn{X(t_k) \vert Y(t_1)=y^*_1,\dots,Y(t_{k-1})=y^*_{k-1},}{Xk | Y1=y1*,\dots,Y(k-1)=y(k-1)*,}
where \eqn{X(t_k)}{Xk}, \eqn{Y(t_k)}{Yk} are the latent state and observable processes, respectively, and \eqn{y^*_k}{yk*} is the data, at time \eqn{t_k}{tk}.

The prediction variance is therefore the variance of this distribution
\deqn{\mathrm{Var}[X(t_k) \vert Y(t_1)=y^*_1,\dots,Y(t_{k-1})=y^*_{k-1}].}{Var[Xk | Y1=y1*,\dots,Y(k-1)=y(k-1)*].}
}
\seealso{
Other particle filter methods: 
\code{\link{bsmc2}()},
\code{\link{cond.logLik}()},
\code{\link{eff.sample.size}()},
\code{\link{filter.mean}()},
\code{\link{filter.traj}()},
\code{\link{mif2}()},
\code{\link{pfilter}()},
\code{\link{pmcmc}()},
\code{\link{pred.mean}()},
\code{\link{saved.states}()},
\code{\link{wpfilter}()}
}
\concept{particle filter methods}
